/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;

public class ResourceUrl {
    public final ResourceType type;
    public final String name;
    public final boolean framework;
    public final boolean create;
    public final boolean theme;

    private ResourceUrl(ResourceType type, String name, boolean framework, boolean create, boolean theme) {
        this.type = type;
        this.name = name;
        this.framework = framework;
        this.create = create;
        this.theme = theme;
    }

    public static ResourceUrl create(ResourceType type, String name, boolean framework, boolean create) {
        return new ResourceUrl(type, name, framework, create, false);
    }

    public static ResourceUrl create(ResourceValue value) {
        return ResourceUrl.create(value.getResourceType(), value.getName(), value.isFramework(), false);
    }

    public static ResourceUrl parse(String url) {
        return ResourceUrl.parse(url, false);
    }

    public static ResourceUrl parse(String url, boolean forceFramework) {
        String typeName;
        ResourceType type;
        boolean isTheme = false;
        if (url.startsWith("?")) {
            isTheme = true;
            String remainder = url.substring("?".length());
            if (url.startsWith("?attr/")) {
                url = "@" + url.substring("?".length());
            } else {
                int colon = url.indexOf(58);
                if (colon != -1) {
                    if (remainder.indexOf(47, colon) == -1) {
                        remainder = remainder.substring(0, colon) + "attr" + '/' + remainder.substring(colon);
                    }
                    url = "@" + remainder;
                } else {
                    int slash = url.indexOf(47);
                    if (slash == -1) {
                        url = "@attr/" + remainder;
                    }
                }
            }
        }
        if (!url.startsWith("@") || ResourceUrl.isNullOrEmpty(url)) {
            return null;
        }
        int typeEnd = url.indexOf(47, 1);
        if (typeEnd == -1) {
            return null;
        }
        int nameBegin = typeEnd + 1;
        boolean create = url.startsWith("@+");
        int typeBegin = create ? 2 : 1;
        int colon = url.lastIndexOf(58, typeEnd);
        boolean framework = forceFramework;
        if (colon != -1) {
            if (url.startsWith("android", typeBegin)) {
                framework = true;
            }
            typeBegin = colon + 1;
        }
        if ((type = ResourceType.getEnum((String)(typeName = url.substring(typeBegin, typeEnd)))) == null) {
            return null;
        }
        String name = url.substring(nameBegin);
        return new ResourceUrl(type, name, framework, create, isTheme);
    }

    public static boolean isNullOrEmpty(String url) {
        return url.equals("@null") || url.equals("@empty") || url.equals("@undefined");
    }

    public boolean hasValidName() {
        if (this.name.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(this.name.charAt(0))) {
            return false;
        }
        int n = this.name.length();
        for (int i = 1; i < n; ++i) {
            char c = this.name.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.theme ? "?" : "@");
        if (this.create) {
            sb.append('+');
        }
        if (this.framework) {
            sb.append("android");
            sb.append(':');
        }
        sb.append(this.type.getName());
        sb.append('/');
        sb.append(this.name);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceUrl that = (ResourceUrl)o;
        if (this.create != that.create) {
            return false;
        }
        if (this.framework != that.framework) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.framework ? 1 : 0);
        result = 31 * result + (this.create ? 1 : 0);
        return result;
    }
}

