/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

public class EditDistance {
    private EditDistance() {
    }

    public static int getEditDistance(String source, String target) {
        return EditDistance.getEditDistance(source, target, true);
    }

    public static int getEditDistance(String source, String target, boolean caseSensitive) {
        int i;
        int targetLength;
        int sourceLength = EditDistance.isEmptyOrWhitespace(source) ? 0 : source.length();
        int n = targetLength = EditDistance.isEmptyOrWhitespace(target) ? 0 : target.length();
        if (sourceLength == 0) {
            return targetLength;
        }
        if (targetLength == 0) {
            return sourceLength;
        }
        if (!caseSensitive) {
            source = source.toLowerCase();
            target = target.toLowerCase();
        }
        int[][] levMatrix = new int[sourceLength + 1][targetLength + 1];
        for (i = 0; i <= sourceLength; ++i) {
            levMatrix[i][0] = i;
        }
        for (i = 0; i <= targetLength; ++i) {
            levMatrix[0][i] = i;
        }
        for (i = 1; i <= sourceLength; ++i) {
            char sourceI = source.charAt(i - 1);
            for (int j = 1; j <= targetLength; ++j) {
                char targetJ = target.charAt(j - 1);
                int cost = 0;
                if (sourceI != targetJ) {
                    cost = 1;
                }
                levMatrix[i][j] = Math.min(cost + levMatrix[i - 1][j - 1], Math.min(levMatrix[i - 1][j] + 1, levMatrix[i][j - 1] + 1));
            }
        }
        return levMatrix[sourceLength][targetLength];
    }

    private static boolean isEmptyOrWhitespace(String source) {
        return source == null || source.matches("\\s*");
    }
}

