/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class ImportStatements {
    private static final Ordering<String> IMPORT_ORDERING = new Ordering<String>(){

        public int compare(String s1, String s2) {
            return ComparisonChain.start().compareTrueFirst(ImportStatements.isStatic(s1), ImportStatements.isStatic(s2)).compare((Comparable)((Object)s1), (Comparable)((Object)s2)).result();
        }
    };
    private int startPos = Integer.MAX_VALUE;
    private int endPos = -1;
    private final SortedSet<String> importStrings;
    private boolean hasExistingImports;

    public static ImportStatements create(JCTree.JCCompilationUnit compilationUnit) {
        return new ImportStatements((JCTree.JCExpression)compilationUnit.getPackageName(), compilationUnit.getImports(), compilationUnit.endPositions);
    }

    public ImportStatements(JCTree.JCExpression packageTree, List<JCTree.JCImport> importTrees, EndPosTable endPositions) {
        if (importTrees.isEmpty()) {
            this.hasExistingImports = false;
            this.endPos = this.startPos = packageTree != null ? packageTree.getEndPosition(endPositions) + 2 : 0;
        } else {
            this.hasExistingImports = true;
            for (JCTree.JCImport importTree : importTrees) {
                int currStartPos = importTree.getStartPosition();
                int currEndPos = importTree.getEndPosition(endPositions);
                this.startPos = Math.min(this.startPos, currStartPos);
                this.endPos = Math.max(this.endPos, currEndPos);
            }
        }
        Preconditions.checkState((this.startPos <= this.endPos ? 1 : 0) != 0);
        this.importStrings = new TreeSet<String>((Comparator<String>)IMPORT_ORDERING);
        this.importStrings.addAll(Lists.transform(importTrees, (Function)new Function<JCTree.JCImport, String>(){

            public String apply(JCTree.JCImport input) {
                String importExpr = input.toString();
                return CharMatcher.whitespace().or(CharMatcher.is((char)';')).trimTrailingFrom((CharSequence)importExpr);
            }
        }));
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public boolean add(String importToAdd) {
        return this.importStrings.add(importToAdd);
    }

    public boolean addAll(Collection<String> importsToAdd) {
        return this.importStrings.addAll(importsToAdd);
    }

    public boolean remove(String importToRemove) {
        return this.importStrings.remove(importToRemove);
    }

    public boolean removeAll(Collection<String> importsToRemove) {
        return this.importStrings.removeAll(importsToRemove);
    }

    public String toString() {
        if (this.importStrings.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (!this.hasExistingImports) {
            result.append('\n');
        }
        boolean first = true;
        boolean prevIsStatic = true;
        for (String importString : this.importStrings) {
            boolean isStatic = ImportStatements.isStatic(importString);
            if (!first && prevIsStatic && !isStatic) {
                result.append('\n');
            }
            result.append(importString).append(";\n");
            prevIsStatic = isStatic;
            first = false;
        }
        String replacementString = result.toString();
        if (!this.hasExistingImports) {
            return replacementString;
        }
        return CharMatcher.whitespace().trimTrailingFrom((CharSequence)replacementString);
    }

    private static boolean isStatic(String importString) {
        return importString.startsWith("import static");
    }
}

