/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.Reusable;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.SimpleAnnotationMirror;
import dagger.producers.ProductionScope;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class Scope {
    private final AnnotationMirror annotationMirror;

    private Scope(AnnotationMirror annotationMirror) {
        this.annotationMirror = (AnnotationMirror)Preconditions.checkNotNull((Object)annotationMirror);
    }

    static ImmutableSet<Scope> scopesOf(Element element) {
        return FluentIterable.from(InjectionAnnotations.getScopes(element)).transform((Function)new Function<AnnotationMirror, Scope>(){

            public Scope apply(AnnotationMirror annotationMirror) {
                return new Scope(annotationMirror);
            }
        }).toSet();
    }

    static Optional<Scope> uniqueScopeOf(Element element) {
        ImmutableSet<? extends AnnotationMirror> scopeAnnotations = InjectionAnnotations.getScopes(element);
        if (scopeAnnotations.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new Scope((AnnotationMirror)Iterables.getOnlyElement(scopeAnnotations)));
    }

    static Scope productionScope(Elements elements) {
        return Scope.scope(elements, ProductionScope.class);
    }

    static Scope singletonScope(Elements elements) {
        return Scope.scope(elements, Singleton.class);
    }

    static Scope reusableScope(Elements elements) {
        return Scope.scope(elements, Reusable.class);
    }

    private static Scope scope(Elements elements, Class<? extends Annotation> scopeAnnotationClass) {
        return new Scope(SimpleAnnotationMirror.of(elements.getTypeElement(scopeAnnotationClass.getCanonicalName())));
    }

    public String getReadableSource() {
        String string = String.valueOf(this.getQualifiedName());
        return ErrorMessages.stripCommonTypePrefixes(string.length() != 0 ? "@".concat(string) : new String("@"));
    }

    public String getQualifiedName() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"Cannot create a stripped source representation of no annotation");
        TypeElement typeElement = MoreTypes.asTypeElement(this.annotationMirror.getAnnotationType());
        return typeElement.getQualifiedName().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Scope) {
            Scope that = (Scope)obj;
            return AnnotationMirrors.equivalence().equivalent((Object)this.annotationMirror, (Object)that.annotationMirror);
        }
        return false;
    }

    public int hashCode() {
        return AnnotationMirrors.equivalence().hash((Object)this.annotationMirror);
    }

    public String toString() {
        return this.annotationMirror.toString();
    }
}

