/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class StringSubject
extends ComparableSubject<StringSubject, String> {
    public StringSubject(FailureStrategy failureStrategy, @Nullable String string) {
        super(failureStrategy, string);
    }

    @Override
    protected String actualCustomStringRepresentation() {
        return StringSubject.quote((CharSequence)this.actual());
    }

    @Override
    public void isEqualTo(@Nullable Object expected) {
        if (this.actual() == null) {
            if (expected != null) {
                if (expected instanceof String) {
                    this.failWithRawMessage("Not true that " + this.actualAsString() + " is equal to <%s>", StringSubject.quote((String)expected));
                } else {
                    this.failWithRawMessage("Not true that " + this.actualAsString() + " is equal to (%s)<%s>", expected.getClass().getName(), expected);
                }
            }
        } else if (expected == null) {
            this.isNull();
        } else if (!(expected instanceof String)) {
            this.failWithRawMessage("Not true that %s is equal to (%s)<%s>", this.actualAsString(), expected.getClass().getName(), expected);
        } else if (!((String)this.actual()).equals(expected)) {
            if (this.internalCustomName() != null) {
                this.failureStrategy.failComparing("\"" + this.internalCustomName() + "\":", (String)expected, (CharSequence)this.actual());
            } else {
                this.failureStrategy.failComparing("", (String)expected, (CharSequence)this.actual());
            }
        }
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(String other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    @Override
    public void isNull() {
        if (this.actual() != null) {
            this.failWithRawMessage("Not true that %s is null", this.actualAsString());
        }
    }

    public void hasLength(int expectedLength) {
        Preconditions.checkArgument((expectedLength >= 0 ? 1 : 0) != 0, (String)"expectedLength(%s) must be >= 0", (int)expectedLength);
        int actualLength = ((String)this.actual()).length();
        if (actualLength != expectedLength) {
            this.failWithRawMessage("Not true that %s has a length of %s. It is %s.", this.actualAsString(), expectedLength, actualLength);
        }
    }

    public void isEmpty() {
        if (this.actual() == null) {
            this.failWithRawMessage("Not true that null reference is empty", new Object[0]);
        } else if (!((String)this.actual()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (this.actual() == null) {
            this.failWithRawMessage("Not true that null reference is not empty", new Object[0]);
        } else if (((String)this.actual()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void contains(CharSequence string) {
        Preconditions.checkNotNull((Object)string);
        if (this.actual() == null) {
            this.failWithRawMessage("Not true that null reference contains <%s>", StringSubject.quote(string));
        } else if (!((String)this.actual()).contains(string)) {
            this.fail("contains", (Object)StringSubject.quote(string));
        }
    }

    public void doesNotContain(CharSequence string) {
        Preconditions.checkNotNull((Object)string);
        if (this.actual() == null) {
            this.failWithRawMessage("Not true that null reference contains <%s>", StringSubject.quote(string));
        } else if (((String)this.actual()).contains(string)) {
            this.failWithRawMessage("%s unexpectedly contains <%s>", this.actualAsString(), StringSubject.quote(string));
        }
    }

    public void startsWith(String string) {
        Preconditions.checkNotNull((Object)string);
        if (this.actual() == null) {
            this.failWithRawMessage("Not true that null reference starts with <%s>", StringSubject.quote(string));
        } else if (!((String)this.actual()).startsWith(string)) {
            this.fail("starts with", (Object)StringSubject.quote(string));
        }
    }

    public void endsWith(String string) {
        Preconditions.checkNotNull((Object)string);
        if (this.actual() == null) {
            this.failWithRawMessage("Not true that null reference ends with <%s>", StringSubject.quote(string));
        } else if (!((String)this.actual()).endsWith(string)) {
            this.fail("ends with", (Object)StringSubject.quote(string));
        }
    }

    public void matches(String regex) {
        if (!((String)this.actual()).matches(regex)) {
            this.fail("matches", (Object)regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void matches(Pattern regex) {
        if (!regex.matcher((CharSequence)this.actual()).matches()) {
            this.fail("matches", (Object)regex);
        }
    }

    public void doesNotMatch(String regex) {
        if (((String)this.actual()).matches(regex)) {
            this.fail("fails to match", (Object)regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void doesNotMatch(Pattern regex) {
        if (regex.matcher((CharSequence)this.actual()).matches()) {
            this.fail("fails to match", (Object)regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void containsMatch(Pattern pattern) {
        if (!pattern.matcher((CharSequence)this.actual()).find()) {
            this.failWithRawMessage("%s should have contained a match for <%s>", this.actualAsString(), pattern);
        }
    }

    public void containsMatch(String regex) {
        if (!Platform.containsMatch((String)this.actual(), regex)) {
            this.failWithRawMessage("%s should have contained a match for <%s>", this.actualAsString(), regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void doesNotContainMatch(Pattern pattern) {
        if (pattern.matcher((CharSequence)this.actual()).find()) {
            this.failWithRawMessage("%s should not have contained a match for <%s>", this.actualAsString(), pattern);
        }
    }

    public void doesNotContainMatch(String regex) {
        if (Platform.containsMatch((String)this.actual(), regex)) {
            this.failWithRawMessage("%s should not have contained a match for <%s>", this.actualAsString(), regex);
        }
    }

    private static String quote(@Nullable CharSequence toBeWrapped) {
        return toBeWrapped == null ? "null" : "\"" + toBeWrapped + "\"";
    }
}

