/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Shorts;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class PrimitiveShortArraySubject
extends AbstractArraySubject<PrimitiveShortArraySubject, short[]> {
    PrimitiveShortArraySubject(FailureStrategy failureStrategy, @Nullable short[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "short";
    }

    @Override
    protected List<Short> listRepresentation() {
        return Shorts.asList((short[])((short[])this.actual()));
    }

    @Override
    public void isEqualTo(Object expected) {
        short[] actual = (short[])this.actual();
        if (actual == expected) {
            return;
        }
        try {
            short[] expectedArray = (short[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.fail("is equal to", (Object)Shorts.asList((short[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        short[] actual = (short[])this.actual();
        try {
            short[] expectedArray = (short[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Shorts.asList((short[])expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public IterableSubject asList() {
        return this.internalCustomName() != null ? (IterableSubject)this.check().that(this.listRepresentation()).named(this.internalCustomName(), new Object[0]) : this.check().that(this.listRepresentation());
    }
}

