/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.Binder;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassWriter;
import com.google.turbine.model.TurbineTyKind;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Transitive {
    public static ImmutableMap<String, byte[]> collectDeps(ImmutableSet<String> bootClassPath, Binder.BindingResult bound) {
        ImmutableMap.Builder transitive = ImmutableMap.builder();
        for (ClassSymbol sym : Transitive.superClosure(bound)) {
            String jarFile;
            BytecodeBoundClass info = bound.classPathEnv().get(sym);
            if (info == null || bootClassPath.contains((Object)(jarFile = info.jarFile()))) continue;
            transitive.put((Object)sym.binaryName(), (Object)ClassWriter.writeClass(Transitive.trimClass(sym, info)));
        }
        return transitive.build();
    }

    private static ClassFile trimClass(ClassSymbol sym, BytecodeBoundClass info) {
        ClassFile cf = info.classFile();
        ImmutableList.Builder fields = ImmutableList.builder();
        for (ClassFile.FieldInfo f : cf.fields()) {
            if (f.value() == null) continue;
            fields.add((Object)f);
        }
        ImmutableList.Builder innerClasses = ImmutableList.builder();
        for (ClassFile.InnerClass i : cf.innerClasses()) {
            if (!i.innerClass().equals(sym.binaryName()) && !i.outerClass().equals(sym.binaryName())) continue;
            innerClasses.add((Object)i);
        }
        return new ClassFile(cf.access(), cf.name(), cf.signature(), cf.superName(), cf.interfaces(), info.kind() == TurbineTyKind.ANNOTATION ? cf.methods() : ImmutableList.of(), (List<ClassFile.FieldInfo>)fields.build(), cf.annotations(), (List<ClassFile.InnerClass>)innerClasses.build(), cf.typeAnnotations());
    }

    private static Set<ClassSymbol> superClosure(Binder.BindingResult bound) {
        CompoundEnv<ClassSymbol, TypeBoundClass> env = CompoundEnv.of(new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(bound.units())).append(bound.classPathEnv());
        LinkedHashSet<ClassSymbol> closure = new LinkedHashSet<ClassSymbol>();
        for (ClassSymbol sym : bound.units().keySet()) {
            Transitive.addSuperTypes(closure, env, sym);
        }
        return closure;
    }

    private static void addSuperTypes(Set<ClassSymbol> closure, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym) {
        if (!closure.add(sym)) {
            return;
        }
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            return;
        }
        closure.addAll((Collection<ClassSymbol>)info.children().values());
        if (info.superclass() != null) {
            Transitive.addSuperTypes(closure, env, info.superclass());
        }
        for (ClassSymbol i : info.interfaces()) {
            Transitive.addSuperTypes(closure, env, i);
        }
    }
}

