/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.lookup.CanonicalSymbolResolver;
import com.google.turbine.binder.lookup.ImportScope;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.tree.Tree;
import java.util.HashMap;
import java.util.Map;

public class ImportIndex
implements ImportScope {
    private final Map<String, Supplier<ImportScope>> thunks;

    public ImportIndex(ImmutableMap<String, Supplier<ImportScope>> thunks) {
        this.thunks = thunks;
    }

    public static ImportIndex create(final CanonicalSymbolResolver resolve, final TopLevelIndex cpi, ImmutableList<Tree.ImportDecl> imports) {
        HashMap<Object, Supplier> thunks = new HashMap<Object, Supplier>();
        for (final Tree.ImportDecl i : imports) {
            if (i.stat() || i.wild()) continue;
            thunks.put(Iterables.getLast(i.type()), Suppliers.memoize((Supplier)new Supplier<ImportScope>(){

                public ImportScope get() {
                    return ImportIndex.namedImport(cpi, i, resolve);
                }
            }));
        }
        for (final Tree.ImportDecl i : imports) {
            String last;
            if (!i.stat() || i.wild() || thunks.containsKey(last = (String)Iterables.getLast(i.type()))) continue;
            thunks.put(last, Suppliers.memoize((Supplier)new Supplier<ImportScope>(){

                public ImportScope get() {
                    return ImportIndex.staticNamedImport(cpi, i);
                }
            }));
        }
        return new ImportIndex((ImmutableMap<String, Supplier<ImportScope>>)ImmutableMap.copyOf(thunks));
    }

    private static ImportScope namedImport(TopLevelIndex cpi, Tree.ImportDecl i, CanonicalSymbolResolver resolve) {
        LookupResult result = cpi.lookup(new LookupKey((Iterable<String>)i.type()));
        if (result == null) {
            return null;
        }
        final ClassSymbol sym = resolve.resolve(result);
        return new ImportScope(){

            @Override
            public LookupResult lookup(LookupKey lookupKey, ImportScope.ResolveFunction unused) {
                return new LookupResult(sym, lookupKey);
            }
        };
    }

    private static ImportScope staticNamedImport(TopLevelIndex cpi, Tree.ImportDecl i) {
        final LookupResult base = cpi.lookup(new LookupKey((Iterable<String>)i.type()));
        if (base == null) {
            return null;
        }
        return new ImportScope(){

            @Override
            public LookupResult lookup(LookupKey lookupKey, ImportScope.ResolveFunction resolve) {
                ClassSymbol result = resolve.resolve(base);
                if (result == null) {
                    return null;
                }
                return new LookupResult(result, lookupKey);
            }
        };
    }

    @Override
    public LookupResult lookup(LookupKey lookup, ImportScope.ResolveFunction resolve) {
        Supplier<ImportScope> thunk = this.thunks.get(lookup.first());
        if (thunk == null) {
            return null;
        }
        ImportScope scope = (ImportScope)thunk.get();
        if (scope == null) {
            return null;
        }
        return scope.lookup(lookup, resolve);
    }
}

