/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class CacheContainsKeyRequest
extends AbstractCacheRequest {
    private Data key;

    public CacheContainsKeyRequest() {
    }

    public CacheContainsKeyRequest(String name, Data key, InMemoryFormat inMemoryFormat) {
        super(name, inMemoryFormat);
        this.key = key;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        CacheOperationProvider operationProvider = this.getOperationProvider();
        return operationProvider.createContainsKeyOperation(this.key);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(this.name, "read");
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key};
    }

    @Override
    public String getMethodName() {
        return "containsKey";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

