/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2PromisedRequestVerifier;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class FixedHttp2ConnectionDecoder
implements Http2ConnectionDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FixedHttp2ConnectionDecoder.class);
    private Http2FrameListener internalFrameListener = new PrefaceFrameListener();
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Http2ConnectionEncoder encoder;
    private final Http2FrameReader frameReader;
    private Http2FrameListener listener;
    private final Http2PromisedRequestVerifier requestVerifier;

    public FixedHttp2ConnectionDecoder(Http2Connection connection, Http2ConnectionEncoder encoder, Http2FrameReader frameReader) {
        this(connection, encoder, frameReader, Http2PromisedRequestVerifier.ALWAYS_VERIFY);
    }

    public FixedHttp2ConnectionDecoder(Http2Connection connection, Http2ConnectionEncoder encoder, Http2FrameReader frameReader, Http2PromisedRequestVerifier requestVerifier) {
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)connection, (String)"connection");
        this.frameReader = (Http2FrameReader)ObjectUtil.checkNotNull((Object)frameReader, (String)"frameReader");
        this.encoder = (Http2ConnectionEncoder)ObjectUtil.checkNotNull((Object)encoder, (String)"encoder");
        this.requestVerifier = (Http2PromisedRequestVerifier)ObjectUtil.checkNotNull((Object)requestVerifier, (String)"requestVerifier");
        if (connection.local().flowController() == null) {
            connection.local().flowController((Http2FlowController)new DefaultHttp2LocalFlowController(connection));
        }
        ((Http2LocalFlowController)connection.local().flowController()).frameWriter(encoder.frameWriter());
    }

    public void lifecycleManager(Http2LifecycleManager lifecycleManager) {
        this.lifecycleManager = (Http2LifecycleManager)ObjectUtil.checkNotNull((Object)lifecycleManager, (String)"lifecycleManager");
    }

    public Http2Connection connection() {
        return this.connection;
    }

    public final Http2LocalFlowController flowController() {
        return (Http2LocalFlowController)this.connection.local().flowController();
    }

    public void frameListener(Http2FrameListener listener) {
        this.listener = (Http2FrameListener)ObjectUtil.checkNotNull((Object)listener, (String)"listener");
    }

    public Http2FrameListener frameListener() {
        return this.listener;
    }

    Http2FrameListener internalFrameListener() {
        return this.internalFrameListener;
    }

    public boolean prefaceReceived() {
        return FrameReadListener.class == this.internalFrameListener.getClass();
    }

    public void decodeFrame(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Http2Exception {
        this.frameReader.readFrame(ctx, in, this.internalFrameListener);
    }

    public Http2Settings localSettings() {
        Http2Settings settings = new Http2Settings();
        Http2FrameReader.Configuration config = this.frameReader.configuration();
        Http2HeadersDecoder.Configuration headersConfig = config.headersConfiguration();
        Http2FrameSizePolicy frameSizePolicy = config.frameSizePolicy();
        settings.initialWindowSize(this.flowController().initialWindowSize());
        settings.maxConcurrentStreams((long)this.connection.remote().maxActiveStreams());
        settings.headerTableSize(headersConfig.maxHeaderTableSize());
        settings.maxFrameSize(frameSizePolicy.maxFrameSize());
        settings.maxHeaderListSize(headersConfig.maxHeaderListSize());
        if (!this.connection.isServer()) {
            settings.pushEnabled(this.connection.local().allowPushTo());
        }
        return settings;
    }

    public void close() {
        this.frameReader.close();
    }

    protected long calculateMaxHeaderListSizeGoAway(long maxHeaderListSize) {
        return Http2CodecUtil.calculateMaxHeaderListSizeGoAway((long)maxHeaderListSize);
    }

    private int unconsumedBytes(Http2Stream stream) {
        return this.flowController().unconsumedBytes(stream);
    }

    void onGoAwayRead0(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
        if (this.connection.goAwayReceived() && this.connection.local().lastStreamKnownByPeer() < lastStreamId) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"lastStreamId MUST NOT increase. Current value: %d new value: %d", (Object[])new Object[]{this.connection.local().lastStreamKnownByPeer(), lastStreamId});
        }
        this.listener.onGoAwayRead(ctx, lastStreamId, errorCode, debugData);
        this.connection.goAwayReceived(lastStreamId, errorCode, debugData);
    }

    void onUnknownFrame0(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
        this.listener.onUnknownFrame(ctx, frameType, streamId, flags, payload);
    }

    private final class PrefaceFrameListener
    implements Http2FrameListener {
        private PrefaceFrameListener() {
        }

        private void verifyPrefaceReceived() throws Http2Exception {
            if (!FixedHttp2ConnectionDecoder.this.prefaceReceived()) {
                throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Received non-SETTINGS as first frame.", (Object[])new Object[0]);
            }
        }

        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            this.verifyPrefaceReceived();
            return FixedHttp2ConnectionDecoder.this.internalFrameListener.onDataRead(ctx, streamId, data, padding, endOfStream);
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
            this.verifyPrefaceReceived();
            FixedHttp2ConnectionDecoder.this.internalFrameListener.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
            this.verifyPrefaceReceived();
            FixedHttp2ConnectionDecoder.this.internalFrameListener.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream);
        }

        public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
            this.verifyPrefaceReceived();
            FixedHttp2ConnectionDecoder.this.internalFrameListener.onPriorityRead(ctx, streamId, streamDependency, weight, exclusive);
        }

        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            this.verifyPrefaceReceived();
            FixedHttp2ConnectionDecoder.this.internalFrameListener.onRstStreamRead(ctx, streamId, errorCode);
        }

        public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
            this.verifyPrefaceReceived();
            FixedHttp2ConnectionDecoder.this.internalFrameListener.onSettingsAckRead(ctx);
        }

        public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
            if (!FixedHttp2ConnectionDecoder.this.prefaceReceived()) {
                FixedHttp2ConnectionDecoder.this.internalFrameListener = new FrameReadListener();
            }
            FixedHttp2ConnectionDecoder.this.internalFrameListener.onSettingsRead(ctx, settings);
        }

        public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
            this.verifyPrefaceReceived();
            FixedHttp2ConnectionDecoder.this.internalFrameListener.onPingRead(ctx, data);
        }

        public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
            this.verifyPrefaceReceived();
            FixedHttp2ConnectionDecoder.this.internalFrameListener.onPingAckRead(ctx, data);
        }

        public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
            this.verifyPrefaceReceived();
            FixedHttp2ConnectionDecoder.this.internalFrameListener.onPushPromiseRead(ctx, streamId, promisedStreamId, headers, padding);
        }

        public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
            FixedHttp2ConnectionDecoder.this.onGoAwayRead0(ctx, lastStreamId, errorCode, debugData);
        }

        public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
            this.verifyPrefaceReceived();
            FixedHttp2ConnectionDecoder.this.internalFrameListener.onWindowUpdateRead(ctx, streamId, windowSizeIncrement);
        }

        public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
            FixedHttp2ConnectionDecoder.this.onUnknownFrame0(ctx, frameType, streamId, flags, payload);
        }
    }

    private final class FrameReadListener
    implements Http2FrameListener {
        private FrameReadListener() {
        }

        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            boolean shouldIgnore;
            Http2Stream stream = FixedHttp2ConnectionDecoder.this.connection.stream(streamId);
            Http2LocalFlowController flowController = FixedHttp2ConnectionDecoder.this.flowController();
            int bytesToReturn = data.readableBytes() + padding;
            try {
                shouldIgnore = this.shouldIgnoreHeadersOrDataFrame(ctx, streamId, stream, "DATA");
            }
            catch (Http2Exception e) {
                flowController.receiveFlowControlledFrame(stream, data, padding, endOfStream);
                flowController.consumeBytes(stream, bytesToReturn);
                throw e;
            }
            catch (Throwable t) {
                throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)t, (String)"Unhandled error on data stream id %d", (Object[])new Object[]{streamId});
            }
            if (shouldIgnore) {
                flowController.receiveFlowControlledFrame(stream, data, padding, endOfStream);
                flowController.consumeBytes(stream, bytesToReturn);
                this.verifyStreamMayHaveExisted(streamId);
                return bytesToReturn;
            }
            Http2Exception error = null;
            switch (stream.state()) {
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                case HALF_CLOSED_REMOTE: 
                case CLOSED: {
                    error = Http2Exception.streamError((int)stream.id(), (Http2Error)Http2Error.STREAM_CLOSED, (String)"Stream %d in unexpected state: %s", (Object[])new Object[]{stream.id(), stream.state()});
                    break;
                }
                default: {
                    error = Http2Exception.streamError((int)stream.id(), (Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Stream %d in unexpected state: %s", (Object[])new Object[]{stream.id(), stream.state()});
                }
            }
            int unconsumedBytes = FixedHttp2ConnectionDecoder.this.unconsumedBytes(stream);
            try {
                flowController.receiveFlowControlledFrame(stream, data, padding, endOfStream);
                unconsumedBytes = FixedHttp2ConnectionDecoder.this.unconsumedBytes(stream);
                if (error != null) {
                    throw error;
                }
                int n = bytesToReturn = FixedHttp2ConnectionDecoder.this.listener.onDataRead(ctx, streamId, data, padding, endOfStream);
                return n;
            }
            catch (Http2Exception e) {
                int delta = unconsumedBytes - FixedHttp2ConnectionDecoder.this.unconsumedBytes(stream);
                bytesToReturn -= delta;
                throw e;
            }
            catch (RuntimeException e) {
                int delta = unconsumedBytes - FixedHttp2ConnectionDecoder.this.unconsumedBytes(stream);
                bytesToReturn -= delta;
                throw e;
            }
            finally {
                flowController.consumeBytes(stream, bytesToReturn);
                if (endOfStream) {
                    FixedHttp2ConnectionDecoder.this.lifecycleManager.closeStreamRemote(stream, ctx.newSucceededFuture());
                }
            }
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
            this.onHeadersRead(ctx, streamId, headers, 0, (short)16, false, padding, endOfStream);
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
            Http2Stream stream = FixedHttp2ConnectionDecoder.this.connection.stream(streamId);
            boolean allowHalfClosedRemote = false;
            if (stream == null && !FixedHttp2ConnectionDecoder.this.connection.streamMayHaveExisted(streamId)) {
                stream = FixedHttp2ConnectionDecoder.this.connection.remote().createStream(streamId, endOfStream);
                boolean bl = allowHalfClosedRemote = stream.state() == Http2Stream.State.HALF_CLOSED_REMOTE;
            }
            if (this.shouldIgnoreHeadersOrDataFrame(ctx, streamId, stream, "HEADERS")) {
                return;
            }
            switch (stream.state()) {
                case RESERVED_REMOTE: {
                    stream.open(endOfStream);
                    break;
                }
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                case HALF_CLOSED_REMOTE: {
                    if (allowHalfClosedRemote) break;
                    throw Http2Exception.streamError((int)stream.id(), (Http2Error)Http2Error.STREAM_CLOSED, (String)"Stream %d in unexpected state: %s", (Object[])new Object[]{stream.id(), stream.state()});
                }
                case CLOSED: {
                    throw Http2Exception.streamError((int)stream.id(), (Http2Error)Http2Error.STREAM_CLOSED, (String)"Stream %d in unexpected state: %s", (Object[])new Object[]{stream.id(), stream.state()});
                }
                default: {
                    throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Stream %d in unexpected state: %s", (Object[])new Object[]{stream.id(), stream.state()});
                }
            }
            try {
                stream.setPriority(streamDependency, weight, exclusive);
            }
            catch (Http2Exception.ClosedStreamCreationException closedStreamCreationException) {
                // empty catch block
            }
            FixedHttp2ConnectionDecoder.this.listener.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream);
            if (endOfStream) {
                FixedHttp2ConnectionDecoder.this.lifecycleManager.closeStreamRemote(stream, ctx.newSucceededFuture());
            }
        }

        public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
            Http2Stream stream = FixedHttp2ConnectionDecoder.this.connection.stream(streamId);
            try {
                if (stream == null) {
                    if (FixedHttp2ConnectionDecoder.this.connection.streamMayHaveExisted(streamId)) {
                        logger.info("{} ignoring PRIORITY frame for stream {}. Stream doesn't exist but may  have existed", (Object)ctx.channel(), (Object)streamId);
                        return;
                    }
                    stream = FixedHttp2ConnectionDecoder.this.connection.remote().createIdleStream(streamId);
                } else if (this.streamCreatedAfterGoAwaySent(streamId)) {
                    logger.info("{} ignoring PRIORITY frame for stream {}. Stream created after GOAWAY sent. Last known stream by peer {}", new Object[]{ctx.channel(), streamId, FixedHttp2ConnectionDecoder.this.connection.remote().lastStreamKnownByPeer()});
                    return;
                }
                stream.setPriority(streamDependency, weight, exclusive);
            }
            catch (Http2Exception.ClosedStreamCreationException closedStreamCreationException) {
                // empty catch block
            }
            FixedHttp2ConnectionDecoder.this.listener.onPriorityRead(ctx, streamId, streamDependency, weight, exclusive);
        }

        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            Http2Stream stream = FixedHttp2ConnectionDecoder.this.connection.stream(streamId);
            if (stream == null) {
                this.verifyStreamMayHaveExisted(streamId);
                return;
            }
            switch (stream.state()) {
                case IDLE: {
                    throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"RST_STREAM received for IDLE stream %d", (Object[])new Object[]{streamId});
                }
                case CLOSED: {
                    return;
                }
            }
            FixedHttp2ConnectionDecoder.this.listener.onRstStreamRead(ctx, streamId, errorCode);
            FixedHttp2ConnectionDecoder.this.lifecycleManager.closeStream(stream, ctx.newSucceededFuture());
        }

        public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
            Http2Settings settings = FixedHttp2ConnectionDecoder.this.encoder.pollSentSettings();
            if (settings != null) {
                this.applyLocalSettings(settings);
            }
            FixedHttp2ConnectionDecoder.this.listener.onSettingsAckRead(ctx);
        }

        private void applyLocalSettings(Http2Settings settings) throws Http2Exception {
            Integer initialWindowSize;
            Integer maxFrameSize;
            Long maxHeaderListSize;
            Long headerTableSize;
            Long maxConcurrentStreams;
            Boolean pushEnabled = settings.pushEnabled();
            Http2FrameReader.Configuration config = FixedHttp2ConnectionDecoder.this.frameReader.configuration();
            Http2HeadersDecoder.Configuration headerConfig = config.headersConfiguration();
            Http2FrameSizePolicy frameSizePolicy = config.frameSizePolicy();
            if (pushEnabled != null) {
                if (FixedHttp2ConnectionDecoder.this.connection.isServer()) {
                    throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Server sending SETTINGS frame with ENABLE_PUSH specified", (Object[])new Object[0]);
                }
                FixedHttp2ConnectionDecoder.this.connection.local().allowPushTo(pushEnabled.booleanValue());
            }
            if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
                int value = (int)Math.min(maxConcurrentStreams, Integer.MAX_VALUE);
                FixedHttp2ConnectionDecoder.this.connection.remote().maxStreams(value, this.calculateMaxStreams(value));
            }
            if ((headerTableSize = settings.headerTableSize()) != null) {
                headerConfig.maxHeaderTableSize(headerTableSize.longValue());
            }
            if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
                headerConfig.maxHeaderListSize(maxHeaderListSize.longValue(), FixedHttp2ConnectionDecoder.this.calculateMaxHeaderListSizeGoAway(maxHeaderListSize));
            }
            if ((maxFrameSize = settings.maxFrameSize()) != null) {
                frameSizePolicy.maxFrameSize(maxFrameSize.intValue());
            }
            if ((initialWindowSize = settings.initialWindowSize()) != null) {
                FixedHttp2ConnectionDecoder.this.flowController().initialWindowSize(initialWindowSize.intValue());
            }
        }

        private int calculateMaxStreams(int maxConcurrentStreams) {
            int maxStreams = maxConcurrentStreams + 100;
            return maxStreams < 0 ? Integer.MAX_VALUE : maxStreams;
        }

        public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
            FixedHttp2ConnectionDecoder.this.encoder.writeSettingsAck(ctx, ctx.newPromise());
            FixedHttp2ConnectionDecoder.this.encoder.remoteSettings(settings);
            FixedHttp2ConnectionDecoder.this.listener.onSettingsRead(ctx, settings);
        }

        public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
            FixedHttp2ConnectionDecoder.this.encoder.writePing(ctx, true, data.retainedSlice(), ctx.newPromise());
            FixedHttp2ConnectionDecoder.this.listener.onPingRead(ctx, data);
        }

        public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
            FixedHttp2ConnectionDecoder.this.listener.onPingAckRead(ctx, data);
        }

        public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
            if (FixedHttp2ConnectionDecoder.this.connection().isServer()) {
                throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"A client cannot push.", (Object[])new Object[0]);
            }
            Http2Stream parentStream = FixedHttp2ConnectionDecoder.this.connection.stream(streamId);
            if (this.shouldIgnoreHeadersOrDataFrame(ctx, streamId, parentStream, "PUSH_PROMISE")) {
                return;
            }
            if (parentStream == null) {
                throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Stream %d does not exist", (Object[])new Object[]{streamId});
            }
            switch (parentStream.state()) {
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                default: {
                    throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Stream %d in unexpected state for receiving push promise: %s", (Object[])new Object[]{parentStream.id(), parentStream.state()});
                }
            }
            if (!FixedHttp2ConnectionDecoder.this.requestVerifier.isAuthoritative(ctx, headers)) {
                throw Http2Exception.streamError((int)promisedStreamId, (Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Promised request on stream %d for promised stream %d is not authoritative", (Object[])new Object[]{streamId, promisedStreamId});
            }
            if (!FixedHttp2ConnectionDecoder.this.requestVerifier.isCacheable(headers)) {
                throw Http2Exception.streamError((int)promisedStreamId, (Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Promised request on stream %d for promised stream %d is not known to be cacheable", (Object[])new Object[]{streamId, promisedStreamId});
            }
            if (!FixedHttp2ConnectionDecoder.this.requestVerifier.isSafe(headers)) {
                throw Http2Exception.streamError((int)promisedStreamId, (Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Promised request on stream %d for promised stream %d is not known to be safe", (Object[])new Object[]{streamId, promisedStreamId});
            }
            FixedHttp2ConnectionDecoder.this.connection.remote().reservePushStream(promisedStreamId, parentStream);
            FixedHttp2ConnectionDecoder.this.listener.onPushPromiseRead(ctx, streamId, promisedStreamId, headers, padding);
        }

        public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
            FixedHttp2ConnectionDecoder.this.onGoAwayRead0(ctx, lastStreamId, errorCode, debugData);
        }

        public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
            Http2Stream stream = FixedHttp2ConnectionDecoder.this.connection.stream(streamId);
            if (stream == null || stream.state() == Http2Stream.State.CLOSED || this.streamCreatedAfterGoAwaySent(streamId)) {
                this.verifyStreamMayHaveExisted(streamId);
                return;
            }
            FixedHttp2ConnectionDecoder.this.encoder.flowController().incrementWindowSize(stream, windowSizeIncrement);
            FixedHttp2ConnectionDecoder.this.listener.onWindowUpdateRead(ctx, streamId, windowSizeIncrement);
        }

        public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
            FixedHttp2ConnectionDecoder.this.onUnknownFrame0(ctx, frameType, streamId, flags, payload);
        }

        private boolean shouldIgnoreHeadersOrDataFrame(ChannelHandlerContext ctx, int streamId, Http2Stream stream, String frameName) throws Http2Exception {
            if (stream == null) {
                if (this.streamCreatedAfterGoAwaySent(streamId)) {
                    logger.info("{} ignoring {} frame for stream {}. Stream sent after GOAWAY sent", new Object[]{ctx.channel(), frameName, streamId});
                    return true;
                }
                throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.STREAM_CLOSED, (String)"Received %s frame for an unknown stream %d", (Object[])new Object[]{frameName, streamId});
            }
            if (stream.isResetSent() || this.streamCreatedAfterGoAwaySent(streamId)) {
                if (logger.isInfoEnabled()) {
                    logger.info("{} ignoring {} frame for stream {} {}", new Object[]{ctx.channel(), frameName, stream.isResetSent() ? "RST_STREAM sent." : "Stream created after GOAWAY sent. Last known stream by peer " + FixedHttp2ConnectionDecoder.this.connection.remote().lastStreamKnownByPeer()});
                }
                return true;
            }
            return false;
        }

        private boolean streamCreatedAfterGoAwaySent(int streamId) {
            Http2Connection.Endpoint remote = FixedHttp2ConnectionDecoder.this.connection.remote();
            return FixedHttp2ConnectionDecoder.this.connection.goAwaySent() && remote.isValidStreamId(streamId) && streamId > remote.lastStreamKnownByPeer();
        }

        private void verifyStreamMayHaveExisted(int streamId) throws Http2Exception {
            if (!FixedHttp2ConnectionDecoder.this.connection.streamMayHaveExisted(streamId)) {
                throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Stream %d does not exist", (Object[])new Object[]{streamId});
            }
        }
    }
}

