/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

@BugPattern(name="FragmentNotInstantiable", altNames={"ValidFragment"}, summary="Subclasses of Fragment must be instantiable via Class#newInstance(): the class must be public, static and have a public nullary constructor", category=BugPattern.Category.ANDROID, severity=BugPattern.SeverityLevel.WARNING)
public class FragmentNotInstantiable
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String MESSAGE_BASE = "Fragment is not instantiable: ";
    private static final String FRAGMENT_CLASS = "android.app.Fragment";
    private static final String FRAGMENT_CLASS_V4 = "android.support.v4.app.Fragment";
    private final ImmutableSet<String> fragmentClasses;
    private final Matcher<ClassTree> fragmentMatcher;

    public FragmentNotInstantiable() {
        this((Iterable<String>)ImmutableSet.of());
    }

    protected FragmentNotInstantiable(Iterable<String> additionalFragmentClasses) {
        this.fragmentClasses = ImmutableSet.builder().add((Object)FRAGMENT_CLASS).add((Object)FRAGMENT_CLASS_V4).addAll(additionalFragmentClasses).build();
        this.fragmentMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.CLASS), Matchers.anyOf((Iterable)this.fragmentClasses.stream().map(fragmentClass -> Matchers.isSubtypeOf((String)fragmentClass)).collect(Collectors.toList()))});
    }

    private Description buildErrorMessage(Tree tree, String explanation) {
        Description.Builder description = this.buildDescription(tree);
        description.setMessage(MESSAGE_BASE + explanation + ".");
        return description.build();
    }

    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!this.fragmentMatcher.matches((Tree)classTree, state)) {
            return Description.NO_MATCH;
        }
        String className = ASTHelpers.getSymbol((ClassTree)classTree).toString();
        if (this.fragmentClasses.contains((Object)className)) {
            return Description.NO_MATCH;
        }
        if (classTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) {
            return Description.NO_MATCH;
        }
        if (!classTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
            return this.buildErrorMessage(classTree, "a fragment must be public");
        }
        if (Matchers.nestingKind((NestingKind)NestingKind.MEMBER).matches((Tree)classTree, state) && !ASTHelpers.getSymbol((ClassTree)classTree).isStatic()) {
            return this.buildErrorMessage(classTree, "a fragment inner class must be static");
        }
        List constructors = ASTHelpers.getConstructors((ClassTree)classTree);
        for (MethodTree constructor : constructors) {
            if (!constructor.getParameters().isEmpty()) continue;
            if (!constructor.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
                return this.buildErrorMessage(constructor, "the nullary constructor must be public");
            }
            return Description.NO_MATCH;
        }
        return this.buildErrorMessage(classTree, "the nullary constructor is missing");
    }
}

