/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@BugPattern(name="ReturnValueIgnored", altNames={"ResultOfMethodCallIgnored", "CheckReturnValue"}, summary="Return value of this method must be used", explanation="Certain library methods do nothing useful if their return value is ignored. For example, String.trim() has no side effects, and you must store the return value of String.intern() to access the interned string.  This check encodes a list of methods in the JDK whose return value must be used and issues an error if they are not.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class ReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final Set<String> typesToCheck = new HashSet<String>(Arrays.asList("java.lang.String", "java.math.BigInteger", "java.math.BigDecimal", "java.nio.file.Path"));
    private static final Matcher<ExpressionTree> RETURNS_SAME_TYPE = Matchers.allOf((Matcher[])new Matcher[]{ReturnValueIgnored.methodReceiverHasType(typesToCheck), ReturnValueIgnored.methodReturnsSameTypeAsReceiver()});
    private static final Matcher<MethodInvocationTree> FUNCTIONAL_METHOD = (Matcher & Serializable)(tree, state) -> {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        return symbol != null && symbol.owner.packge().getQualifiedName().contentEquals("java.util.function");
    };
    private static final Matcher<ExpressionTree> STREAM_METHOD = MethodMatchers.instanceMethod().onDescendantOf("java.util.stream.BaseStream");

    @Override
    public Matcher<? super MethodInvocationTree> specializedMatcher() {
        return Matchers.anyOf((Matcher[])new Matcher[]{RETURNS_SAME_TYPE, FUNCTIONAL_METHOD, STREAM_METHOD});
    }

    private static Matcher<ExpressionTree> methodReturnsSameTypeAsReceiver() {
        return new Matcher<ExpressionTree>(){

            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                return ASTHelpers.isSameType((Type)ASTHelpers.getReceiverType((ExpressionTree)expressionTree), (Type)ASTHelpers.getReturnType((ExpressionTree)expressionTree), (VisitorState)state);
            }
        };
    }

    private static Matcher<ExpressionTree> methodReceiverHasType(final Set<String> typeSet) {
        return new Matcher<ExpressionTree>(){

            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                Type receiverType = ASTHelpers.getReceiverType((ExpressionTree)expressionTree);
                return typeSet.contains(receiverType.toString());
            }
        };
    }
}

