/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.regex.Pattern;

@BugPattern(name="PreconditionsInvalidPlaceholder", summary="Preconditions only accepts the %s placeholder in error message strings", explanation="The Guava Preconditions checks take error message template strings that look similar to format strings but only accept %s as a placeholder. This check points out places where there is a non-%s placeholder in a Preconditions error message template string and the number of arguments does not match the number of %s placeholders.", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.WARNING)
public class PreconditionsInvalidPlaceholder
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> PRECONDITIONS_CHECK = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkArgument"), Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkState")});
    private static final Pattern BAD_PLACEHOLDER_REGEX = Pattern.compile("\\$s|%(?:\\d+\\$)??[dbBhHScCdoxXeEfgGaAtTn]|\\{\\d+\\}");

    private static int expectedArguments(String formatString) {
        int count = 0;
        int i = formatString.indexOf("%s");
        while (i != -1) {
            ++count;
            i = formatString.indexOf("%s", i + 1);
        }
        return count;
    }

    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        String formatString;
        int expectedArgs;
        LiteralTree formatStringTree;
        if (PRECONDITIONS_CHECK.matches((Tree)t, state) && t.getArguments().size() >= 2 && t.getArguments().get(1) instanceof LiteralTree && (formatStringTree = (LiteralTree)t.getArguments().get(1)).getValue() instanceof String && (expectedArgs = PreconditionsInvalidPlaceholder.expectedArguments(formatString = (String)formatStringTree.getValue())) < t.getArguments().size() - 2 && BAD_PLACEHOLDER_REGEX.matcher(formatString).find()) {
            return this.describe(t, state);
        }
        return Description.NO_MATCH;
    }

    public Description describe(MethodInvocationTree t, VisitorState state) {
        LiteralTree formatTree = (LiteralTree)t.getArguments().get(1);
        String fixedFormatString = BAD_PLACEHOLDER_REGEX.matcher(state.getSourceForNode((Tree)((JCTree)((Object)formatTree)))).replaceAll("%s");
        if (PreconditionsInvalidPlaceholder.expectedArguments(fixedFormatString) == t.getArguments().size() - 2) {
            return this.describeMatch(formatTree, (Fix)SuggestedFix.replace((Tree)formatTree, (String)fixedFormatString));
        }
        int missing = t.getArguments().size() - 2 - PreconditionsInvalidPlaceholder.expectedArguments(fixedFormatString);
        StringBuilder builder = new StringBuilder(fixedFormatString);
        builder.deleteCharAt(builder.length() - 1);
        builder.append(" [%s");
        for (int i = 1; i < missing; ++i) {
            builder.append(", %s");
        }
        builder.append("]\"");
        return this.describeMatch(t, (Fix)SuggestedFix.replace((Tree)formatTree, (String)builder.toString()));
    }
}

