/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnalysis;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="ImmutableAnnotationChecker", altNames={"Immutable"}, category=BugPattern.Category.JDK, summary="Annotations should always be immutable", severity=BugPattern.SeverityLevel.WARNING)
public class ImmutableAnnotationChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public static final String ANNOTATED_ANNOTATION_MESSAGE = "annotations are immutable by default; annotating them with @Immutable is unnecessary";

    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableAnalysis.Violation info;
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)tree);
        if (symbol == null || symbol.isAnnotationType() || !WellKnownMutability.isAnnotation(state, symbol.type)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol, Immutable.class, (VisitorState)state)) {
            AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"Immutable");
            if (annotation != null) {
                state.reportMatch(this.buildDescription(annotation).setMessage(ANNOTATED_ANNOTATION_MESSAGE).addFix((Fix)SuggestedFix.delete((Tree)annotation)).build());
            } else {
                state.reportMatch(this.buildDescription(tree).setMessage(ANNOTATED_ANNOTATION_MESSAGE).build());
            }
        }
        if (!(info = new ImmutableAnalysis(this, state, "annotations should be immutable, and cannot have non-final fields", "annotations should be immutable").checkForImmutability((Optional<ClassTree>)Optional.of((Object)tree), (ImmutableSet<String>)ImmutableSet.of(), ASTHelpers.getType((ClassTree)tree))).isPresent()) {
            return Description.NO_MATCH;
        }
        String message = "annotations should be immutable: " + info.message();
        return this.buildDescription(tree).setMessage(message).build();
    }
}

