/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByBinder;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.GuardedBySymbolResolver;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public abstract class AbstractLockMethodChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    protected abstract ImmutableList<String> getLockExpressions(MethodTree var1);

    protected abstract Set<GuardedByExpression> getActual(MethodTree var1, VisitorState var2);

    protected abstract Set<GuardedByExpression> getUnwanted(MethodTree var1, VisitorState var2);

    protected abstract String buildMessage(String var1);

    public Description matchMethod(MethodTree tree, VisitorState state) {
        ImmutableList<String> lockExpressions = this.getLockExpressions(tree);
        if (lockExpressions.isEmpty()) {
            return Description.NO_MATCH;
        }
        Optional<ImmutableSet<GuardedByExpression>> expected = AbstractLockMethodChecker.parseLockExpressions(lockExpressions, tree, state);
        if (!expected.isPresent()) {
            return this.buildDescription(tree).setMessage("Could not resolve lock expression.").build();
        }
        Set<GuardedByExpression> unwanted = this.getUnwanted(tree, state);
        Sets.SetView mishandled = Sets.intersection((Set)((Set)expected.get()), unwanted);
        if (!mishandled.isEmpty()) {
            String message = this.buildMessage(AbstractLockMethodChecker.formatLockString((Set<GuardedByExpression>)mishandled));
            return this.buildDescription(tree).setMessage(message).build();
        }
        Set<GuardedByExpression> actual = this.getActual(tree, state);
        Sets.SetView unhandled = Sets.difference((Set)((Set)expected.get()), actual);
        if (!unhandled.isEmpty()) {
            String message = this.buildMessage(AbstractLockMethodChecker.formatLockString((Set<GuardedByExpression>)unhandled));
            return this.buildDescription(tree).setMessage(message).build();
        }
        return Description.NO_MATCH;
    }

    private static String formatLockString(Set<GuardedByExpression> locks) {
        ImmutableList sortedUnhandled = FluentIterable.from(locks).transform(Functions.toStringFunction()).toSortedList((Comparator)Ordering.natural());
        return Joiner.on((String)", ").join((Iterable)sortedUnhandled);
    }

    private static Optional<ImmutableSet<GuardedByExpression>> parseLockExpressions(List<String> lockExpressions, Tree tree, VisitorState state) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String lockExpression : lockExpressions) {
            Optional<GuardedByExpression> guard = GuardedByBinder.bindString(lockExpression, GuardedBySymbolResolver.from(tree, state));
            if (!guard.isPresent()) {
                return Optional.absent();
            }
            builder.add(guard.get());
        }
        return Optional.of((Object)builder.build());
    }
}

