/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import javax.lang.model.element.ElementKind;

@BugPattern(name="CheckReturnValue", altNames={"ResultOfMethodCallIgnored", "ReturnValueIgnored"}, summary="Ignored return value of method that is annotated with @CheckReturnValue", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class CheckReturnValue
extends AbstractReturnValueIgnored
implements BugChecker.MethodTreeMatcher,
BugChecker.ClassTreeMatcher {
    private static final String CHECK_RETURN_VALUE = "CheckReturnValue";
    private static final Matcher<MethodInvocationTree> MATCHER = new Matcher<MethodInvocationTree>(){

        public boolean matches(MethodInvocationTree tree, VisitorState state) {
            Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodInvocationTree)tree);
            Optional result = CheckReturnValue.shouldCheckReturnValue(method, state);
            if (result.isPresent()) {
                return (Boolean)result.get();
            }
            result = CheckReturnValue.checkEnclosingClasses(method, state);
            if (result.isPresent()) {
                return (Boolean)result.get();
            }
            result = CheckReturnValue.checkPackage(method, state);
            if (result.isPresent()) {
                return (Boolean)result.get();
            }
            return false;
        }
    };
    private static final String BOTH_ERROR = "@CheckReturnValue and @CanIgnoreReturnValue cannot both be applied to the same %s";

    private static Optional<Boolean> shouldCheckReturnValue(Symbol sym, VisitorState state) {
        if (ASTHelpers.hasAnnotation((Symbol)sym, CanIgnoreReturnValue.class, (VisitorState)state)) {
            return Optional.of((Object)false);
        }
        if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)sym, (String)CHECK_RETURN_VALUE)) {
            return Optional.of((Object)true);
        }
        return Optional.absent();
    }

    private static Optional<Boolean> checkEnclosingClasses(Symbol.MethodSymbol method, VisitorState state) {
        Symbol enclosingClass = ASTHelpers.enclosingClass((Symbol)method);
        while (enclosingClass instanceof Symbol.ClassSymbol) {
            Optional<Boolean> result = CheckReturnValue.shouldCheckReturnValue(enclosingClass, state);
            if (result.isPresent()) {
                return result;
            }
            enclosingClass = enclosingClass.owner;
        }
        return Optional.absent();
    }

    private static Optional<Boolean> checkPackage(Symbol.MethodSymbol method, VisitorState state) {
        return CheckReturnValue.shouldCheckReturnValue(ASTHelpers.enclosingPackage((Symbol)method), state);
    }

    public Matcher<MethodInvocationTree> specializedMatcher() {
        return MATCHER;
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        String annotationToValidate;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)tree);
        boolean checkReturn = ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)method, (String)CHECK_RETURN_VALUE);
        boolean canIgnore = ASTHelpers.hasAnnotation((Symbol)method, CanIgnoreReturnValue.class, (VisitorState)state);
        if (checkReturn && canIgnore) {
            return this.buildDescription(tree).setMessage(String.format(BOTH_ERROR, "method")).build();
        }
        if (checkReturn) {
            annotationToValidate = javax.annotation.CheckReturnValue.class.getSimpleName();
        } else if (canIgnore) {
            annotationToValidate = CanIgnoreReturnValue.class.getSimpleName();
        } else {
            return Description.NO_MATCH;
        }
        if (method.getKind() != ElementKind.METHOD) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isVoidType((Type)method.getReturnType(), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        String message = String.format("@%s may not be applied to void-returning methods", annotationToValidate);
        return this.buildDescription(tree).setMessage(message).build();
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)ASTHelpers.getSymbol((ClassTree)tree), (String)CHECK_RETURN_VALUE) && ASTHelpers.hasAnnotation((Tree)tree, CanIgnoreReturnValue.class, (VisitorState)state)) {
            return this.buildDescription(tree).setMessage(String.format(BOTH_ERROR, "class")).build();
        }
        return Description.NO_MATCH;
    }
}

