/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;

public class LambdaToMethod
extends TreeTranslator {
    private Attr attr;
    private JCDiagnostic.Factory diags;
    private Log log;
    private Lower lower;
    private Names names;
    private Symtab syms;
    private Resolve rs;
    private Operators operators;
    private TreeMaker make;
    private Types types;
    private TransTypes transTypes;
    private Env<AttrContext> attrEnv;
    private LambdaAnalyzerPreprocessor analyzer;
    private Map<JCTree, LambdaAnalyzerPreprocessor.TranslationContext<?>> contextMap;
    private LambdaAnalyzerPreprocessor.TranslationContext<?> context;
    private KlassInfo kInfo;
    private final boolean dumpLambdaToMethodStats;
    private final boolean forceSerializable;
    public static final int FLAG_SERIALIZABLE = 1;
    public static final int FLAG_MARKERS = 2;
    public static final int FLAG_BRIDGES = 4;
    protected static final Context.Key<LambdaToMethod> unlambdaKey = new Context.Key();

    public static LambdaToMethod instance(Context context) {
        LambdaToMethod lambdaToMethod = context.get(unlambdaKey);
        if (lambdaToMethod == null) {
            lambdaToMethod = new LambdaToMethod(context);
        }
        return lambdaToMethod;
    }

    private LambdaToMethod(Context context) {
        context.put(unlambdaKey, this);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.lower = Lower.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.rs = Resolve.instance(context);
        this.operators = Operators.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.analyzer = new LambdaAnalyzerPreprocessor();
        Options options = Options.instance(context);
        this.dumpLambdaToMethodStats = options.isSet("debug.dumpLambdaToMethodStats");
        this.attr = Attr.instance(context);
        this.forceSerializable = options.isSet("forceSerializable");
    }

    @Override
    public <T extends JCTree> T translate(T t) {
        LambdaAnalyzerPreprocessor.TranslationContext<?> translationContext = this.contextMap.get(t);
        return this.translate(t, translationContext != null ? translationContext : this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends JCTree> T translate(T t, LambdaAnalyzerPreprocessor.TranslationContext<?> translationContext) {
        LambdaAnalyzerPreprocessor.TranslationContext<?> translationContext2 = this.context;
        try {
            this.context = translationContext;
            T t2 = super.translate(t);
            return t2;
        }
        finally {
            this.context = translationContext2;
        }
    }

    <T extends JCTree> List<T> translate(List<T> list, LambdaAnalyzerPreprocessor.TranslationContext<?> translationContext) {
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        for (JCTree jCTree : list) {
            listBuffer.append(this.translate(jCTree, translationContext));
        }
        return listBuffer.toList();
    }

    public JCTree translateTopLevelClass(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
        this.make = treeMaker;
        this.attrEnv = env;
        this.context = null;
        this.contextMap = new HashMap();
        return this.translate(jCTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        if (jCClassDecl.sym.owner.kind == Kinds.Kind.PCK) {
            jCClassDecl = this.analyzer.analyzeAndPreprocessClass(jCClassDecl);
        }
        KlassInfo klassInfo = this.kInfo;
        try {
            this.kInfo = new KlassInfo(jCClassDecl);
            super.visitClassDef(jCClassDecl);
            if (!this.kInfo.deserializeCases.isEmpty()) {
                int n = this.make.pos;
                try {
                    this.make.at(jCClassDecl);
                    this.kInfo.addMethod(this.makeDeserializeMethod(jCClassDecl.sym));
                }
                finally {
                    this.make.at(n);
                }
            }
            List list = this.kInfo.appendedMethodList.toList();
            jCClassDecl.defs = jCClassDecl.defs.appendList(list);
            for (JCTree jCTree : list) {
                jCClassDecl.sym.members().enter(((JCTree.JCMethodDecl)jCTree).sym);
            }
            this.result = jCClassDecl;
        }
        finally {
            this.kInfo = klassInfo;
        }
    }

    @Override
    public void visitLambda(JCTree.JCLambda jCLambda) {
        JCTree.JCExpression jCExpression;
        LambdaAnalyzerPreprocessor.LambdaTranslationContext lambdaTranslationContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
        Symbol.MethodSymbol methodSymbol = lambdaTranslationContext.translatedSym;
        Type.MethodType methodType = (Type.MethodType)methodSymbol.type;
        Object object = lambdaTranslationContext.owner;
        this.apportionTypeAnnotations(jCLambda, ((Symbol)object)::getRawTypeAttributes, ((Symbol)object)::setTypeAttributes, methodSymbol::setTypeAttributes);
        boolean bl = ((Symbol)object).name == this.names.init;
        if (bl || ((Symbol)object).name == this.names.clinit) {
            object = ((Symbol)object).owner;
            this.apportionTypeAnnotations(jCLambda, bl ? ((Symbol)object)::getInitTypeAttributes : ((Symbol)object)::getClassInitTypeAttributes, bl ? ((Symbol)object)::setInitTypeAttributes : ((Symbol)object)::setClassInitTypeAttributes, methodSymbol::appendUniqueTypeAttributes);
        }
        if (lambdaTranslationContext.self != null && lambdaTranslationContext.self.getKind() == ElementKind.FIELD) {
            object = lambdaTranslationContext.self;
            this.apportionTypeAnnotations(jCLambda, ((Symbol)object)::getRawTypeAttributes, ((Symbol)object)::setTypeAttributes, methodSymbol::appendUniqueTypeAttributes);
        }
        object = this.make.MethodDef(this.make.Modifiers(methodSymbol.flags_field), methodSymbol.name, this.make.QualIdent(methodType.getReturnType().tsym), List.nil(), lambdaTranslationContext.syntheticParams, methodType.getThrownTypes() == null ? List.nil() : this.make.Types((List<Type>)methodType.getThrownTypes()), null, null);
        ((JCTree.JCMethodDecl)object).sym = methodSymbol;
        ((JCTree.JCMethodDecl)object).type = methodType;
        ((JCTree.JCMethodDecl)object).body = this.translate(this.makeLambdaBody(jCLambda, (JCTree.JCMethodDecl)object));
        this.kInfo.addMethod((JCTree)object);
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (lambdaTranslationContext.methodReferenceReceiver != null) {
            listBuffer.append(lambdaTranslationContext.methodReferenceReceiver);
        } else if (!methodSymbol.isStatic()) {
            listBuffer.append(this.makeThis((Type)methodSymbol.owner.enclClass().asType(), lambdaTranslationContext.owner.enclClass()));
        }
        for (Symbol symbol : lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.CAPTURED_VAR).keySet()) {
            if (symbol == lambdaTranslationContext.self) continue;
            jCExpression = this.make.Ident(symbol).setType(symbol.type);
            listBuffer.append(jCExpression);
        }
        for (Symbol symbol : lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.CAPTURED_OUTER_THIS).keySet()) {
            jCExpression = this.make.QualThis(symbol.type);
            listBuffer.append(jCExpression);
        }
        List list = this.translate(listBuffer.toList(), lambdaTranslationContext.prev);
        int n = this.referenceKind(methodSymbol);
        this.result = this.makeMetafactoryIndyCall(this.context, n, methodSymbol, list);
    }

    private void apportionTypeAnnotations(JCTree.JCLambda jCLambda, Supplier<List<Attribute.TypeCompound>> supplier, Consumer<List<Attribute.TypeCompound>> consumer, Consumer<List<Attribute.TypeCompound>> consumer2) {
        ListBuffer<Attribute.TypeCompound> listBuffer = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Attribute.TypeCompound> listBuffer2 = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound typeCompound : supplier.get()) {
            if (typeCompound.position.onLambda == jCLambda) {
                listBuffer2.append(typeCompound);
                continue;
            }
            listBuffer.append(typeCompound);
        }
        if (listBuffer2.nonEmpty()) {
            consumer.accept(listBuffer.toList());
            consumer2.accept(listBuffer2.toList());
        }
    }

    private JCTree.JCIdent makeThis(Type type, Symbol symbol) {
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0x200001010L, this.names._this, type, symbol);
        return this.make.Ident(varSymbol);
    }

    @Override
    public void visitReference(JCTree.JCMemberReference jCMemberReference) {
        JCTree.JCExpression jCExpression;
        LambdaAnalyzerPreprocessor.ReferenceTranslationContext referenceTranslationContext = (LambdaAnalyzerPreprocessor.ReferenceTranslationContext)this.context;
        Symbol symbol = referenceTranslationContext.isSignaturePolymorphic() ? referenceTranslationContext.sigPolySym : jCMemberReference.sym;
        switch (jCMemberReference.kind) {
            case IMPLICIT_INNER: 
            case SUPER: {
                jCExpression = this.makeThis((Type)referenceTranslationContext.owner.enclClass().asType(), referenceTranslationContext.owner.enclClass());
                break;
            }
            case BOUND: {
                jCExpression = jCMemberReference.getQualifierExpression();
                jCExpression = this.attr.makeNullCheck(jCExpression);
                break;
            }
            case UNBOUND: 
            case STATIC: 
            case TOPLEVEL: 
            case ARRAY_CTOR: {
                jCExpression = null;
                break;
            }
            default: {
                throw new InternalError("Should not have an invalid kind");
            }
        }
        List<JCTree.JCExpression> list = jCExpression == null ? List.nil() : this.translate(List.of(jCExpression), referenceTranslationContext.prev);
        this.result = this.makeMetafactoryIndyCall(referenceTranslationContext, referenceTranslationContext.referenceKind(), symbol, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        if (this.context == null || !this.analyzer.lambdaIdentSymbolFilter(jCIdent.sym)) {
            super.visitIdent(jCIdent);
        } else {
            int n = this.make.pos;
            try {
                this.make.at(jCIdent);
                LambdaAnalyzerPreprocessor.LambdaTranslationContext lambdaTranslationContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
                JCTree jCTree = lambdaTranslationContext.translate(jCIdent);
                if (jCTree != null) {
                    this.result = jCTree;
                } else {
                    super.visitIdent(jCIdent);
                }
            }
            finally {
                this.make.at(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        if (this.context == null || !this.analyzer.lambdaFieldAccessFilter(jCFieldAccess)) {
            super.visitSelect(jCFieldAccess);
        } else {
            int n = this.make.pos;
            try {
                this.make.at(jCFieldAccess);
                LambdaAnalyzerPreprocessor.LambdaTranslationContext lambdaTranslationContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
                JCTree jCTree = lambdaTranslationContext.translate(jCFieldAccess);
                if (jCTree != null) {
                    this.result = jCTree;
                } else {
                    super.visitSelect(jCFieldAccess);
                }
            }
            finally {
                this.make.at(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        LambdaAnalyzerPreprocessor.LambdaTranslationContext lambdaTranslationContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
        if (this.context != null && lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.LOCAL_VAR).containsKey(jCVariableDecl.sym)) {
            jCVariableDecl.init = this.translate(jCVariableDecl.init);
            jCVariableDecl.sym = (Symbol.VarSymbol)lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.LOCAL_VAR).get(jCVariableDecl.sym);
            this.result = jCVariableDecl;
        } else if (this.context != null && lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.TYPE_VAR).containsKey(jCVariableDecl.sym)) {
            JCTree.JCExpression jCExpression = this.translate(jCVariableDecl.init);
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.TYPE_VAR).get(jCVariableDecl.sym);
            int n = this.make.pos;
            try {
                this.result = this.make.at(jCVariableDecl).VarDef(varSymbol, jCExpression);
            }
            finally {
                this.make.at(n);
            }
            Scope.WriteableScope writeableScope = jCVariableDecl.sym.owner.members();
            if (writeableScope != null) {
                writeableScope.remove(jCVariableDecl.sym);
                writeableScope.enter(varSymbol);
            }
        } else {
            super.visitVarDef(jCVariableDecl);
        }
    }

    private JCTree.JCBlock makeLambdaBody(JCTree.JCLambda jCLambda, JCTree.JCMethodDecl jCMethodDecl) {
        return jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION ? this.makeLambdaExpressionBody((JCTree.JCExpression)jCLambda.body, jCMethodDecl) : this.makeLambdaStatementBody((JCTree.JCBlock)jCLambda.body, jCMethodDecl, jCLambda.canCompleteNormally);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCBlock makeLambdaExpressionBody(JCTree.JCExpression jCExpression, JCTree.JCMethodDecl jCMethodDecl) {
        Type type = jCMethodDecl.type.getReturnType();
        boolean bl = jCExpression.type.hasTag(TypeTag.VOID);
        boolean bl2 = type.hasTag(TypeTag.VOID);
        boolean bl3 = this.types.isSameType(type, this.types.boxedClass((Type)this.syms.voidType).type);
        int n = this.make.pos;
        try {
            if (bl2) {
                JCTree.JCExpressionStatement jCExpressionStatement = this.make.at(jCExpression).Exec(jCExpression);
                JCTree.JCBlock jCBlock = this.make.Block(0L, List.of(jCExpressionStatement));
                return jCBlock;
            }
            if (bl && bl3) {
                ListBuffer<JCTree.JCStatement> listBuffer = new ListBuffer<JCTree.JCStatement>();
                listBuffer.append(this.make.at(jCExpression).Exec(jCExpression));
                listBuffer.append(this.make.Return(this.make.Literal(TypeTag.BOT, null).setType(this.syms.botType)));
                JCTree.JCBlock jCBlock = this.make.Block(0L, listBuffer.toList());
                return jCBlock;
            }
            JCTree.JCExpression jCExpression2 = this.transTypes.coerce(this.attrEnv, jCExpression, type);
            JCTree.JCBlock jCBlock = this.make.at(jCExpression2).Block(0L, List.of(this.make.Return(jCExpression2)));
            return jCBlock;
        }
        finally {
            this.make.at(n);
        }
    }

    private JCTree.JCBlock makeLambdaStatementBody(JCTree.JCBlock jCBlock, final JCTree.JCMethodDecl jCMethodDecl, boolean bl) {
        final Type type = jCMethodDecl.type.getReturnType();
        final boolean bl2 = type.hasTag(TypeTag.VOID);
        boolean bl3 = this.types.isSameType(type, this.types.boxedClass((Type)this.syms.voidType).type);
        class LambdaBodyTranslator
        extends TreeTranslator {
            LambdaBodyTranslator() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
                this.result = jCClassDecl;
            }

            @Override
            public void visitLambda(JCTree.JCLambda jCLambda) {
                this.result = jCLambda;
            }

            @Override
            public void visitReturn(JCTree.JCReturn jCReturn) {
                boolean bl;
                boolean bl22 = bl = jCReturn.expr == null;
                if (bl2 && !bl) {
                    Symbol.VarSymbol varSymbol = LambdaToMethod.this.makeSyntheticVar(0L, LambdaToMethod.this.names.fromString("$loc"), jCReturn.expr.type, jCMethodDecl.sym);
                    JCTree.JCVariableDecl jCVariableDecl = LambdaToMethod.this.make.VarDef(varSymbol, jCReturn.expr);
                    this.result = LambdaToMethod.this.make.Block(0L, List.of(jCVariableDecl, LambdaToMethod.this.make.Return(null)));
                } else if (!bl2 || !bl) {
                    jCReturn.expr = LambdaToMethod.this.transTypes.coerce(LambdaToMethod.this.attrEnv, jCReturn.expr, type);
                    this.result = jCReturn;
                } else {
                    this.result = jCReturn;
                }
            }
        }
        JCTree.JCBlock jCBlock2 = new LambdaBodyTranslator().translate(jCBlock);
        if (bl && bl3) {
            jCBlock2.stats = jCBlock2.stats.append(this.make.Return(this.make.Literal(TypeTag.BOT, null).setType(this.syms.botType)));
        }
        return jCBlock2;
    }

    private JCTree.JCMethodDecl makeDeserializeMethod(Symbol symbol) {
        JCTree jCTree2;
        ListBuffer<JCTree.JCCase> listBuffer = new ListBuffer<JCTree.JCCase>();
        ListBuffer<JCTree.JCBreak> listBuffer2 = new ListBuffer<JCTree.JCBreak>();
        for (Map.Entry object2 : this.kInfo.deserializeCases.entrySet()) {
            jCTree2 = this.make.Break(null);
            listBuffer2.add((JCTree.JCBreak)jCTree2);
            List<JCTree.JCStatement> list = ((ListBuffer)object2.getValue()).append(jCTree2).toList();
            listBuffer.add(this.make.Case(this.make.Literal(object2.getKey()), list));
        }
        JCTree.JCSwitch jCSwitch = this.make.Switch(this.deserGetter("getImplMethodName", this.syms.stringType), listBuffer.toList());
        for (JCTree jCTree2 : listBuffer2) {
            jCTree2.target = jCSwitch;
        }
        JCTree.JCBlock jCBlock = this.make.Block(0L, List.of(jCSwitch, this.make.Throw(this.makeNewClass(this.syms.illegalArgumentExceptionType, List.of(this.make.Literal("Invalid lambda deserialization"))))));
        jCTree2 = this.make.MethodDef(this.make.Modifiers(this.kInfo.deserMethodSym.flags()), this.names.deserializeLambda, this.make.QualIdent(((KlassInfo)this.kInfo).deserMethodSym.getReturnType().tsym), List.nil(), List.of(this.make.VarDef(this.kInfo.deserParamSym, null)), List.nil(), jCBlock, null);
        ((JCTree.JCMethodDecl)jCTree2).sym = this.kInfo.deserMethodSym;
        ((JCTree.JCMethodDecl)jCTree2).type = ((KlassInfo)this.kInfo).deserMethodSym.type;
        return jCTree2;
    }

    JCTree.JCNewClass makeNewClass(Type type, List<JCTree.JCExpression> list, Symbol symbol) {
        JCTree.JCNewClass jCNewClass = this.make.NewClass(null, null, this.make.QualIdent(type.tsym), list, null);
        jCNewClass.constructor = symbol;
        jCNewClass.type = type;
        return jCNewClass;
    }

    JCTree.JCNewClass makeNewClass(Type type, List<JCTree.JCExpression> list) {
        return this.makeNewClass(type, list, this.rs.resolveConstructor(null, this.attrEnv, type, TreeInfo.types(list), List.nil()));
    }

    private void addDeserializationCase(int n, Symbol symbol, Type type, Symbol.MethodSymbol methodSymbol, JCDiagnostic.DiagnosticPosition diagnosticPosition, List<Object> list, Type.MethodType methodType) {
        ListBuffer listBuffer3;
        String string = this.classSig(type);
        String string2 = ((Name)methodSymbol.getSimpleName()).toString();
        String string3 = this.typeSig(this.types.erasure(methodSymbol.type));
        String string4 = this.classSig(this.types.erasure(symbol.owner.type));
        String string5 = symbol.getQualifiedName().toString();
        String string6 = this.typeSig(this.types.erasure(symbol.type));
        JCTree.JCExpression jCExpression = this.eqTest(this.syms.intType, this.deserGetter("getImplMethodKind", this.syms.intType), this.make.Literal(n));
        ListBuffer<JCTree.JCTypeCast> listBuffer2 = new ListBuffer<JCTree.JCTypeCast>();
        int n2 = 0;
        for (ListBuffer listBuffer3 : methodType.getParameterTypes()) {
            List<JCTree.JCExpression> list2 = new ListBuffer<JCTree.JCLiteral>().append(this.make.Literal(n2)).toList();
            List<Type> list3 = new ListBuffer<Type.JCPrimitiveType>().append(this.syms.intType).toList();
            listBuffer2.add(this.make.TypeCast(this.types.erasure((Type)((Object)listBuffer3)), this.deserGetter("getCapturedArg", this.syms.objectType, list3, list2)));
            ++n2;
        }
        JCTree.JCIf jCIf = this.make.If(this.deserTest(this.deserTest(this.deserTest(this.deserTest(this.deserTest(jCExpression, "getFunctionalInterfaceClass", string), "getFunctionalInterfaceMethodName", string2), "getFunctionalInterfaceMethodSignature", string3), "getImplClass", string4), "getImplMethodSignature", string6), this.make.Return(this.makeIndyCall(diagnosticPosition, this.syms.lambdaMetafactory, this.names.altMetafactory, list, methodType, listBuffer2.toList(), methodSymbol.name)), null);
        listBuffer3 = (ListBuffer)this.kInfo.deserializeCases.get(string5);
        if (listBuffer3 == null) {
            listBuffer3 = new ListBuffer();
            this.kInfo.deserializeCases.put(string5, listBuffer3);
        }
        listBuffer3.append(jCIf);
    }

    private JCTree.JCExpression eqTest(Type type, JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        JCTree.JCBinary jCBinary = this.make.Binary(JCTree.Tag.EQ, jCExpression, jCExpression2);
        jCBinary.operator = this.operators.resolveBinary(jCBinary, JCTree.Tag.EQ, type, type);
        jCBinary.setType(this.syms.booleanType);
        return jCBinary;
    }

    private JCTree.JCExpression deserTest(JCTree.JCExpression jCExpression, String string, String string2) {
        Type.MethodType methodType = new Type.MethodType(List.of(this.syms.objectType), this.syms.booleanType, List.nil(), this.syms.methodClass);
        Symbol symbol = this.rs.resolveQualifiedMethod(null, this.attrEnv, this.syms.objectType, this.names.equals, List.of(this.syms.objectType), List.nil());
        JCTree.JCMethodInvocation jCMethodInvocation = this.make.Apply(List.nil(), this.make.Select(this.deserGetter(string, this.syms.stringType), symbol).setType(methodType), List.of(this.make.Literal(string2)));
        jCMethodInvocation.setType(this.syms.booleanType);
        JCTree.JCBinary jCBinary = this.make.Binary(JCTree.Tag.AND, jCExpression, jCMethodInvocation);
        jCBinary.operator = this.operators.resolveBinary(jCBinary, JCTree.Tag.AND, this.syms.booleanType, this.syms.booleanType);
        jCBinary.setType(this.syms.booleanType);
        return jCBinary;
    }

    private JCTree.JCExpression deserGetter(String string, Type type) {
        return this.deserGetter(string, type, List.nil(), List.nil());
    }

    private JCTree.JCExpression deserGetter(String string, Type type, List<Type> list, List<JCTree.JCExpression> list2) {
        Type.MethodType methodType = new Type.MethodType(list, type, List.nil(), this.syms.methodClass);
        Symbol symbol = this.rs.resolveQualifiedMethod(null, this.attrEnv, this.syms.serializedLambdaType, this.names.fromString(string), list, List.nil());
        return this.make.Apply(List.nil(), this.make.Select(this.make.Ident(this.kInfo.deserParamSym).setType(this.syms.serializedLambdaType), symbol).setType(methodType), list2).setType(type);
    }

    private Symbol.MethodSymbol makePrivateSyntheticMethod(long l, Name name, Type type, Symbol symbol) {
        return new Symbol.MethodSymbol(l | 0x1000L | 2L, name, type, symbol);
    }

    private Symbol.VarSymbol makeSyntheticVar(long l, String string, Type type, Symbol symbol) {
        return this.makeSyntheticVar(l, this.names.fromString(string), type, symbol);
    }

    private Symbol.VarSymbol makeSyntheticVar(long l, Name name, Type type, Symbol symbol) {
        return new Symbol.VarSymbol(l | 0x1000L, name, type, symbol);
    }

    private void setVarargsIfNeeded(JCTree jCTree, Type type) {
        if (type != null) {
            switch (jCTree.getTag()) {
                case APPLY: {
                    ((JCTree.JCMethodInvocation)jCTree).varargsElement = type;
                    break;
                }
                case NEWCLASS: {
                    ((JCTree.JCNewClass)jCTree).varargsElement = type;
                    break;
                }
                case TYPECAST: {
                    this.setVarargsIfNeeded(((JCTree.JCTypeCast)jCTree).expr, type);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private List<JCTree.JCExpression> convertArgs(Symbol symbol, List<JCTree.JCExpression> list, Type type) {
        Assert.check(symbol.kind == Kinds.Kind.MTH);
        List<Type> list2 = this.types.erasure(symbol.type).getParameterTypes();
        if (type != null) {
            Assert.check((symbol.flags() & 0x400000000L) != 0L);
        }
        return this.transTypes.translateArgs(list, list2, type, this.attrEnv);
    }

    private Type.MethodType typeToMethodType(Type type) {
        Type type2 = this.types.erasure(type);
        return new Type.MethodType(type2.getParameterTypes(), type2.getReturnType(), type2.getThrownTypes(), this.syms.methodClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression makeMetafactoryIndyCall(LambdaAnalyzerPreprocessor.TranslationContext<?> translationContext, int n, Symbol symbol, List<JCTree.JCExpression> list) {
        Name name;
        Object t = translationContext.tree;
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)this.types.findDescriptorSymbol(((JCTree.JCFunctionalExpression)t).type.tsym);
        List<Object> list2 = List.of(this.typeToMethodType(methodSymbol.type), new Pool.MethodHandle(n, symbol, this.types), this.typeToMethodType(((JCTree.JCFunctionalExpression)t).getDescriptorType(this.types)));
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (JCTree.JCExpression object2 : list) {
            listBuffer.append(object2.type);
        }
        Type.MethodType methodType = new Type.MethodType(listBuffer.toList(), ((JCTree.JCFunctionalExpression)t).type, List.nil(), this.syms.methodClass);
        Name name2 = name = translationContext.needsAltMetafactory() ? this.names.altMetafactory : this.names.metafactory;
        if (translationContext.needsAltMetafactory()) {
            ListBuffer<Symbol.TypeSymbol> listBuffer2 = new ListBuffer<Symbol.TypeSymbol>();
            for (Type bl : ((JCTree.JCFunctionalExpression)t).targets.tail) {
                if (bl.tsym == this.syms.serializableType.tsym) continue;
                listBuffer2.append(bl.tsym);
            }
            int n2 = translationContext.isSerializable() ? 1 : 0;
            boolean bl = listBuffer2.nonEmpty();
            boolean bl2 = translationContext.bridges.nonEmpty();
            if (bl) {
                n2 |= 2;
            }
            if (bl2) {
                n2 |= 4;
            }
            list2 = list2.append(n2);
            if (bl) {
                list2 = list2.append(listBuffer2.length());
                list2 = list2.appendList(listBuffer2.toList());
            }
            if (bl2) {
                list2 = list2.append(translationContext.bridges.length() - 1);
                for (Symbol symbol2 : translationContext.bridges) {
                    Type type = symbol2.erasure(this.types);
                    if (this.types.isSameType(type, methodSymbol.erasure(this.types))) continue;
                    list2 = list2.append(symbol2.erasure(this.types));
                }
            }
            if (translationContext.isSerializable()) {
                int n3 = this.make.pos;
                try {
                    this.make.at(this.kInfo.clazz);
                    this.addDeserializationCase(n, symbol, ((JCTree.JCFunctionalExpression)t).type, methodSymbol, (JCDiagnostic.DiagnosticPosition)t, list2, methodType);
                }
                finally {
                    this.make.at(n3);
                }
            }
        }
        return this.makeIndyCall((JCDiagnostic.DiagnosticPosition)t, this.syms.lambdaMetafactory, name, list2, methodType, list, methodSymbol.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression makeIndyCall(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Name name, List<Object> list, Type.MethodType methodType, List<JCTree.JCExpression> list2, Name name2) {
        int n = this.make.pos;
        try {
            this.make.at(diagnosticPosition);
            List<Type> list3 = List.of(this.syms.methodHandleLookupType, this.syms.stringType, this.syms.methodTypeType).appendList(this.bsmStaticArgToTypes(list));
            Symbol.MethodSymbol methodSymbol = this.rs.resolveInternalMethod(diagnosticPosition, this.attrEnv, type, name, list3, List.nil());
            Symbol.DynamicMethodSymbol dynamicMethodSymbol = new Symbol.DynamicMethodSymbol(name2, this.syms.noSymbol, methodSymbol.isStatic() ? 6 : 5, methodSymbol, methodType, list.toArray());
            JCTree.JCFieldAccess jCFieldAccess = this.make.Select(this.make.QualIdent(type.tsym), name);
            jCFieldAccess.sym = dynamicMethodSymbol;
            jCFieldAccess.type = methodType.getReturnType();
            JCTree.JCMethodInvocation jCMethodInvocation = this.make.Apply(List.nil(), jCFieldAccess, list2);
            jCMethodInvocation.type = methodType.getReturnType();
            JCTree.JCMethodInvocation jCMethodInvocation2 = jCMethodInvocation;
            return jCMethodInvocation2;
        }
        finally {
            this.make.at(n);
        }
    }

    private List<Type> bsmStaticArgToTypes(List<Object> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Object object : list) {
            listBuffer.append(this.bsmStaticArgToType(object));
        }
        return listBuffer.toList();
    }

    private Type bsmStaticArgToType(Object object) {
        Assert.checkNonNull(object);
        if (object instanceof Symbol.ClassSymbol) {
            return this.syms.classType;
        }
        if (object instanceof Integer) {
            return this.syms.intType;
        }
        if (object instanceof Long) {
            return this.syms.longType;
        }
        if (object instanceof Float) {
            return this.syms.floatType;
        }
        if (object instanceof Double) {
            return this.syms.doubleType;
        }
        if (object instanceof String) {
            return this.syms.stringType;
        }
        if (object instanceof Pool.MethodHandle) {
            return this.syms.methodHandleType;
        }
        if (object instanceof Type.MethodType) {
            return this.syms.methodTypeType;
        }
        Assert.error("bad static arg " + object.getClass());
        return null;
    }

    private int referenceKind(Symbol symbol) {
        if (symbol.isConstructor()) {
            return 8;
        }
        if (symbol.isStatic()) {
            return 6;
        }
        if ((symbol.flags() & 2L) != 0L) {
            return 7;
        }
        if (symbol.enclClass().isInterface()) {
            return 9;
        }
        return 5;
    }

    private String typeSig(Type type) {
        L2MSignatureGenerator l2MSignatureGenerator = new L2MSignatureGenerator();
        l2MSignatureGenerator.assembleSig(type);
        return l2MSignatureGenerator.toString();
    }

    private String classSig(Type type) {
        L2MSignatureGenerator l2MSignatureGenerator = new L2MSignatureGenerator();
        l2MSignatureGenerator.assembleClassSig(type);
        return l2MSignatureGenerator.toString();
    }

    private class L2MSignatureGenerator
    extends Types.SignatureGenerator {
        StringBuilder sb;

        L2MSignatureGenerator() {
            super(LambdaToMethod.this.types);
            this.sb = new StringBuilder();
        }

        @Override
        protected void append(char c) {
            this.sb.append(c);
        }

        @Override
        protected void append(byte[] byArray) {
            this.sb.append(new String(byArray));
        }

        @Override
        protected void append(Name name) {
            this.sb.append(name.toString());
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    static enum LambdaSymbolKind {
        PARAM,
        LOCAL_VAR,
        CAPTURED_VAR,
        CAPTURED_THIS,
        CAPTURED_OUTER_THIS,
        TYPE_VAR;

    }

    class LambdaAnalyzerPreprocessor
    extends TreeTranslator {
        private List<Frame> frameStack;
        private int lambdaCount = 0;
        private List<Symbol.ClassSymbol> typesUnderConstruction;
        private SyntheticMethodNameCounter syntheticMethodNameCounts = new SyntheticMethodNameCounter();
        private Map<Symbol, JCTree.JCClassDecl> localClassDefs;
        private Map<Symbol.ClassSymbol, Symbol> clinits = new HashMap<Symbol.ClassSymbol, Symbol>();

        LambdaAnalyzerPreprocessor() {
        }

        private JCTree.JCClassDecl analyzeAndPreprocessClass(JCTree.JCClassDecl jCClassDecl) {
            this.frameStack = List.nil();
            this.typesUnderConstruction = List.nil();
            this.localClassDefs = new HashMap<Symbol, JCTree.JCClassDecl>();
            return this.translate(jCClassDecl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            List<Symbol.ClassSymbol> list = this.typesUnderConstruction;
            try {
                Name name = TreeInfo.name(jCMethodInvocation.meth);
                if (name == ((LambdaToMethod)LambdaToMethod.this).names._this || name == ((LambdaToMethod)LambdaToMethod.this).names._super) {
                    this.typesUnderConstruction = this.typesUnderConstruction.prepend(this.currentClass());
                }
                super.visitApply(jCMethodInvocation);
            }
            finally {
                this.typesUnderConstruction = list;
            }
        }

        private Symbol.ClassSymbol currentClass() {
            for (Frame frame : this.frameStack) {
                if (!frame.tree.hasTag(JCTree.Tag.CLASSDEF)) continue;
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)frame.tree;
                return jCClassDecl.sym;
            }
            return null;
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            List<Frame> list = this.frameStack;
            try {
                if (this.frameStack.nonEmpty() && ((Frame)this.frameStack.head).tree.hasTag(JCTree.Tag.CLASSDEF)) {
                    this.frameStack = this.frameStack.prepend(new Frame(jCBlock));
                }
                super.visitBlock(jCBlock);
            }
            finally {
                this.frameStack = list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            List<Frame> list = this.frameStack;
            int n = this.lambdaCount;
            SyntheticMethodNameCounter syntheticMethodNameCounter = this.syntheticMethodNameCounts;
            Map<Symbol.ClassSymbol, Symbol> map = this.clinits;
            DiagnosticSource diagnosticSource = LambdaToMethod.this.log.currentSource();
            try {
                LambdaToMethod.this.log.useSource(jCClassDecl.sym.sourcefile);
                this.lambdaCount = 0;
                this.syntheticMethodNameCounts = new SyntheticMethodNameCounter();
                map = new HashMap<Symbol.ClassSymbol, Symbol>();
                if (jCClassDecl.sym.owner.kind == Kinds.Kind.MTH) {
                    this.localClassDefs.put(jCClassDecl.sym, jCClassDecl);
                }
                if (this.directlyEnclosingLambda() != null) {
                    jCClassDecl.sym.owner = this.owner();
                    if (jCClassDecl.sym.hasOuterInstance()) {
                        TranslationContext<?> translationContext = this.context();
                        Symbol.TypeSymbol typeSymbol = jCClassDecl.sym.type.getEnclosingType().tsym;
                        while (translationContext != null && !translationContext.owner.isStatic()) {
                            if (((JCTree)translationContext.tree).hasTag(JCTree.Tag.LAMBDA)) {
                                JCTree jCTree = this.capturedDecl(translationContext.depth, typeSymbol);
                                if (jCTree == null) break;
                                ((LambdaTranslationContext)translationContext).addSymbol(typeSymbol, LambdaSymbolKind.CAPTURED_THIS);
                            }
                            translationContext = translationContext.prev;
                        }
                    }
                }
                this.frameStack = this.frameStack.prepend(new Frame(jCClassDecl));
                super.visitClassDef(jCClassDecl);
            }
            finally {
                LambdaToMethod.this.log.useSource(diagnosticSource.getFile());
                this.frameStack = list;
                this.lambdaCount = n;
                this.syntheticMethodNameCounts = syntheticMethodNameCounter;
                this.clinits = map;
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            if (this.context() != null && this.lambdaIdentSymbolFilter(jCIdent.sym)) {
                if (jCIdent.sym.kind == Kinds.Kind.VAR && jCIdent.sym.owner.kind == Kinds.Kind.MTH && jCIdent.type.constValue() == null) {
                    TranslationContext<?> translationContext = this.context();
                    while (translationContext != null) {
                        if (((JCTree)translationContext.tree).getTag() == JCTree.Tag.LAMBDA) {
                            JCTree jCTree = this.capturedDecl(translationContext.depth, jCIdent.sym);
                            if (jCTree == null) break;
                            ((LambdaTranslationContext)translationContext).addSymbol(jCIdent.sym, LambdaSymbolKind.CAPTURED_VAR);
                        }
                        translationContext = translationContext.prev;
                    }
                } else if (jCIdent.sym.owner.kind == Kinds.Kind.TYP) {
                    TranslationContext<?> translationContext = this.context();
                    while (translationContext != null && !translationContext.owner.isStatic()) {
                        if (((JCTree)translationContext.tree).hasTag(JCTree.Tag.LAMBDA)) {
                            JCTree jCTree = this.capturedDecl(translationContext.depth, jCIdent.sym);
                            if (jCTree == null) break;
                            switch (jCTree.getTag()) {
                                case CLASSDEF: {
                                    JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree;
                                    ((LambdaTranslationContext)translationContext).addSymbol(jCClassDecl.sym, LambdaSymbolKind.CAPTURED_THIS);
                                    break;
                                }
                                default: {
                                    Assert.error("bad block kind");
                                }
                            }
                        }
                        translationContext = translationContext.prev;
                    }
                }
            }
            super.visitIdent(jCIdent);
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            this.analyzeLambda(jCLambda, "lambda.stat");
        }

        private void analyzeLambda(JCTree.JCLambda jCLambda, JCTree.JCExpression jCExpression) {
            JCTree.JCExpression jCExpression2 = this.translate(jCExpression);
            LambdaTranslationContext lambdaTranslationContext = this.analyzeLambda(jCLambda, "mref.stat.1");
            if (jCExpression2 != null) {
                lambdaTranslationContext.methodReferenceReceiver = jCExpression2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LambdaTranslationContext analyzeLambda(JCTree.JCLambda jCLambda, String string) {
            List<Frame> list = this.frameStack;
            try {
                LambdaTranslationContext lambdaTranslationContext = new LambdaTranslationContext(jCLambda);
                this.frameStack = this.frameStack.prepend(new Frame(jCLambda));
                for (JCTree.JCVariableDecl jCVariableDecl : jCLambda.params) {
                    lambdaTranslationContext.addSymbol(jCVariableDecl.sym, LambdaSymbolKind.PARAM);
                    ((Frame)this.frameStack.head).addLocal(jCVariableDecl.sym);
                }
                LambdaToMethod.this.contextMap.put(jCLambda, lambdaTranslationContext);
                super.visitLambda(jCLambda);
                lambdaTranslationContext.complete();
                if (LambdaToMethod.this.dumpLambdaToMethodStats) {
                    LambdaToMethod.this.log.note(jCLambda, string, lambdaTranslationContext.needsAltMetafactory(), lambdaTranslationContext.translatedSym);
                }
                LambdaTranslationContext lambdaTranslationContext2 = lambdaTranslationContext;
                return lambdaTranslationContext2;
            }
            finally {
                this.frameStack = list;
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            List<Frame> list = this.frameStack;
            try {
                this.frameStack = this.frameStack.prepend(new Frame(jCMethodDecl));
                super.visitMethodDef(jCMethodDecl);
            }
            finally {
                this.frameStack = list;
            }
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            TranslationContext translationContext;
            Symbol.TypeSymbol typeSymbol = jCNewClass.type.tsym;
            boolean bl = this.currentlyInClass(typeSymbol);
            boolean bl2 = typeSymbol.isLocal();
            if (bl && bl2 || this.lambdaNewClassFilter(this.context(), jCNewClass)) {
                translationContext = this.context();
                Symbol.TypeSymbol typeSymbol2 = jCNewClass.type.getEnclosingType().tsym;
                while (translationContext != null && !translationContext.owner.isStatic()) {
                    if (((JCTree)translationContext.tree).hasTag(JCTree.Tag.LAMBDA)) {
                        JCTree jCTree;
                        if (typeSymbol2 != null && (jCTree = this.capturedDecl(translationContext.depth, typeSymbol2)) == null) break;
                        translationContext.addSymbol(typeSymbol2, LambdaSymbolKind.CAPTURED_THIS);
                    }
                    translationContext = translationContext.prev;
                }
            }
            if (this.context() != null && !bl && bl2) {
                translationContext = (LambdaTranslationContext)this.context();
                this.captureLocalClassDefs(typeSymbol, (LambdaTranslationContext)translationContext);
            }
            super.visitNewClass(jCNewClass);
        }

        void captureLocalClassDefs(Symbol symbol, final LambdaTranslationContext lambdaTranslationContext) {
            JCTree.JCClassDecl jCClassDecl = this.localClassDefs.get(symbol);
            if (jCClassDecl != null && lambdaTranslationContext.freeVarProcessedLocalClasses.add(symbol)) {
                Lower lower = LambdaToMethod.this.lower;
                lower.getClass();
                Lower.BasicFreeVarCollector basicFreeVarCollector = new Lower.BasicFreeVarCollector(lower){

                    @Override
                    void addFreeVars(Symbol.ClassSymbol classSymbol) {
                        LambdaAnalyzerPreprocessor.this.captureLocalClassDefs(classSymbol, lambdaTranslationContext);
                    }

                    @Override
                    void visitSymbol(Symbol symbol) {
                        if (symbol.kind == Kinds.Kind.VAR && symbol.owner.kind == Kinds.Kind.MTH && ((Symbol.VarSymbol)symbol).getConstValue() == null) {
                            TranslationContext<?> translationContext = LambdaAnalyzerPreprocessor.this.context();
                            while (translationContext != null) {
                                if (((JCTree)translationContext.tree).getTag() == JCTree.Tag.LAMBDA) {
                                    JCTree jCTree = LambdaAnalyzerPreprocessor.this.capturedDecl(translationContext.depth, symbol);
                                    if (jCTree == null) break;
                                    ((LambdaTranslationContext)translationContext).addSymbol(symbol, LambdaSymbolKind.CAPTURED_VAR);
                                }
                                translationContext = translationContext.prev;
                            }
                        }
                    }
                };
                basicFreeVarCollector.scan(jCClassDecl);
            }
        }

        boolean currentlyInClass(Symbol symbol) {
            for (Frame frame : this.frameStack) {
                if (!frame.tree.hasTag(JCTree.Tag.CLASSDEF)) continue;
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)frame.tree;
                if (jCClassDecl.sym != symbol) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitReference(JCTree.JCMemberReference jCMemberReference) {
            ReferenceTranslationContext referenceTranslationContext = new ReferenceTranslationContext(jCMemberReference);
            LambdaToMethod.this.contextMap.put(jCMemberReference, referenceTranslationContext);
            if (referenceTranslationContext.needsConversionToLambda()) {
                MemberReferenceToLambda memberReferenceToLambda = new MemberReferenceToLambda(jCMemberReference, referenceTranslationContext, this.owner());
                this.analyzeLambda(memberReferenceToLambda.lambda(), memberReferenceToLambda.getReceiverExpression());
            } else {
                super.visitReference(jCMemberReference);
                if (LambdaToMethod.this.dumpLambdaToMethodStats) {
                    LambdaToMethod.this.log.note(jCMemberReference, "mref.stat", referenceTranslationContext.needsAltMetafactory(), null);
                }
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            if (this.context() != null && jCFieldAccess.sym.kind == Kinds.Kind.VAR && (jCFieldAccess.sym.name == ((LambdaToMethod)LambdaToMethod.this).names._this || jCFieldAccess.sym.name == ((LambdaToMethod)LambdaToMethod.this).names._super)) {
                TranslationContext<?> translationContext = this.context();
                while (translationContext != null && !translationContext.owner.isStatic()) {
                    if (((JCTree)translationContext.tree).hasTag(JCTree.Tag.LAMBDA)) {
                        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)this.capturedDecl(translationContext.depth, jCFieldAccess.sym);
                        if (jCClassDecl == null) break;
                        ((LambdaTranslationContext)translationContext).addSymbol(jCClassDecl.sym, LambdaSymbolKind.CAPTURED_THIS);
                    }
                    translationContext = translationContext.prev;
                }
            }
            super.visitSelect(jCFieldAccess);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            Object object;
            LambdaTranslationContext lambdaTranslationContext;
            TranslationContext<?> translationContext = this.context();
            LambdaTranslationContext lambdaTranslationContext2 = lambdaTranslationContext = translationContext != null && translationContext instanceof LambdaTranslationContext ? (LambdaTranslationContext)translationContext : null;
            if (lambdaTranslationContext != null) {
                if (((Frame)this.frameStack.head).tree.hasTag(JCTree.Tag.LAMBDA)) {
                    lambdaTranslationContext.addSymbol(jCVariableDecl.sym, LambdaSymbolKind.LOCAL_VAR);
                }
                object = jCVariableDecl.sym.asType();
                if (this.inClassWithinLambda() && !LambdaToMethod.this.types.isSameType(LambdaToMethod.this.types.erasure((Type)object), (Type)object)) {
                    lambdaTranslationContext.addSymbol(jCVariableDecl.sym, LambdaSymbolKind.TYPE_VAR);
                }
            }
            object = this.frameStack;
            try {
                if (jCVariableDecl.sym.owner.kind == Kinds.Kind.MTH) {
                    ((Frame)this.frameStack.head).addLocal(jCVariableDecl.sym);
                }
                this.frameStack = this.frameStack.prepend(new Frame(jCVariableDecl));
                super.visitVarDef(jCVariableDecl);
            }
            finally {
                this.frameStack = object;
            }
        }

        private Symbol owner() {
            return this.owner(false);
        }

        private Symbol owner(boolean bl) {
            List<Frame> list = this.frameStack;
            block7: while (list.nonEmpty()) {
                switch (((Frame)list.head).tree.getTag()) {
                    case VARDEF: {
                        if (((JCTree.JCVariableDecl)((Frame)list.head).tree).sym.isLocal()) {
                            list = list.tail;
                            continue block7;
                        }
                        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)((Frame)list.tail.head).tree;
                        return this.initSym(jCClassDecl.sym, ((JCTree.JCVariableDecl)((Frame)list.head).tree).sym.flags() & 8L);
                    }
                    case BLOCK: {
                        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)((Frame)list.tail.head).tree;
                        return this.initSym(jCClassDecl.sym, ((JCTree.JCBlock)((Frame)list.head).tree).flags & 8L);
                    }
                    case CLASSDEF: {
                        return ((JCTree.JCClassDecl)((Frame)list.head).tree).sym;
                    }
                    case METHODDEF: {
                        return ((JCTree.JCMethodDecl)((Frame)list.head).tree).sym;
                    }
                    case LAMBDA: {
                        if (bl) break;
                        return ((LambdaTranslationContext)((LambdaToMethod)LambdaToMethod.this).contextMap.get((Object)((Frame)list.head).tree)).translatedSym;
                    }
                }
                list = list.tail;
            }
            Assert.error();
            return null;
        }

        private Symbol initSym(Symbol.ClassSymbol classSymbol, long l) {
            boolean bl;
            boolean bl2 = bl = (l & 8L) != 0L;
            if (bl) {
                Symbol.MethodSymbol methodSymbol = LambdaToMethod.this.attr.removeClinit(classSymbol);
                if (methodSymbol != null) {
                    this.clinits.put(classSymbol, methodSymbol);
                    return methodSymbol;
                }
                methodSymbol = (Symbol.MethodSymbol)this.clinits.get(classSymbol);
                if (methodSymbol == null) {
                    methodSymbol = LambdaToMethod.this.makePrivateSyntheticMethod(8L, ((LambdaToMethod)LambdaToMethod.this).names.clinit, new Type.MethodType(List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.voidType, List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.methodClass), classSymbol);
                    this.clinits.put(classSymbol, methodSymbol);
                }
                return methodSymbol;
            }
            Iterator<Symbol> iterator = classSymbol.members_field.getSymbolsByName(((LambdaToMethod)LambdaToMethod.this).names.init).iterator();
            if (iterator.hasNext()) {
                Symbol symbol = iterator.next();
                return symbol;
            }
            Assert.error("init not found");
            return null;
        }

        private JCTree directlyEnclosingLambda() {
            if (this.frameStack.isEmpty()) {
                return null;
            }
            List<Frame> list = this.frameStack;
            while (list.nonEmpty()) {
                switch (((Frame)list.head).tree.getTag()) {
                    case CLASSDEF: 
                    case METHODDEF: {
                        return null;
                    }
                    case LAMBDA: {
                        return ((Frame)list.head).tree;
                    }
                }
                list = list.tail;
            }
            Assert.error();
            return null;
        }

        private boolean inClassWithinLambda() {
            if (this.frameStack.isEmpty()) {
                return false;
            }
            List<Frame> list = this.frameStack;
            boolean bl = false;
            block4: while (list.nonEmpty()) {
                switch (((Frame)list.head).tree.getTag()) {
                    case LAMBDA: {
                        return bl;
                    }
                    case CLASSDEF: {
                        bl = true;
                        list = list.tail;
                        continue block4;
                    }
                }
                list = list.tail;
            }
            return false;
        }

        private JCTree capturedDecl(int n, Symbol symbol) {
            int n2 = this.frameStack.size() - 1;
            for (Frame frame : this.frameStack) {
                switch (frame.tree.getTag()) {
                    case CLASSDEF: {
                        Symbol.ClassSymbol classSymbol = ((JCTree.JCClassDecl)frame.tree).sym;
                        if (!classSymbol.isSubClass(symbol, LambdaToMethod.this.types) && !symbol.isMemberOf(classSymbol, LambdaToMethod.this.types)) break;
                        return n2 > n ? null : frame.tree;
                    }
                    case VARDEF: {
                        if (((JCTree.JCVariableDecl)frame.tree).sym != symbol || symbol.owner.kind != Kinds.Kind.MTH) break;
                        return n2 > n ? null : frame.tree;
                    }
                    case BLOCK: 
                    case METHODDEF: 
                    case LAMBDA: {
                        if (frame.locals == null || !frame.locals.contains(symbol)) break;
                        return n2 > n ? null : frame.tree;
                    }
                    default: {
                        Assert.error("bad decl kind " + (Object)((Object)frame.tree.getTag()));
                    }
                }
                --n2;
            }
            return null;
        }

        private TranslationContext<?> context() {
            for (Frame frame : this.frameStack) {
                TranslationContext translationContext = (TranslationContext)LambdaToMethod.this.contextMap.get(frame.tree);
                if (translationContext == null) continue;
                return translationContext;
            }
            return null;
        }

        private boolean lambdaIdentSymbolFilter(Symbol symbol) {
            return (symbol.kind == Kinds.Kind.VAR || symbol.kind == Kinds.Kind.MTH) && !symbol.isStatic() && symbol.name != ((LambdaToMethod)LambdaToMethod.this).names.init;
        }

        private boolean lambdaFieldAccessFilter(JCTree.JCFieldAccess jCFieldAccess) {
            LambdaTranslationContext lambdaTranslationContext = LambdaToMethod.this.context instanceof LambdaTranslationContext ? (LambdaTranslationContext)LambdaToMethod.this.context : null;
            return lambdaTranslationContext != null && !jCFieldAccess.sym.isStatic() && jCFieldAccess.name == ((LambdaToMethod)LambdaToMethod.this).names._this && jCFieldAccess.sym.owner.kind == Kinds.Kind.TYP && !lambdaTranslationContext.translatedSymbols.get((Object)LambdaSymbolKind.CAPTURED_OUTER_THIS).isEmpty();
        }

        private boolean lambdaNewClassFilter(TranslationContext<?> translationContext, JCTree.JCNewClass jCNewClass) {
            if (translationContext != null && jCNewClass.encl == null && jCNewClass.def == null && !jCNewClass.type.getEnclosingType().hasTag(TypeTag.NONE)) {
                Type type = jCNewClass.type.getEnclosingType();
                Type type2 = translationContext.owner.enclClass().type;
                while (!type2.hasTag(TypeTag.NONE)) {
                    if (type2.tsym.isSubClass(type.tsym, LambdaToMethod.this.types)) {
                        return true;
                    }
                    type2 = type2.getEnclosingType();
                }
                return false;
            }
            return false;
        }

        final class ReferenceTranslationContext
        extends TranslationContext<JCTree.JCMemberReference> {
            final boolean isSuper;
            final Symbol sigPolySym;

            ReferenceTranslationContext(JCTree.JCMemberReference jCMemberReference) {
                super(LambdaAnalyzerPreprocessor.this, (JCTree.JCFunctionalExpression)jCMemberReference);
                this.isSuper = jCMemberReference.hasKind(JCTree.JCMemberReference.ReferenceKind.SUPER);
                this.sigPolySym = this.isSignaturePolymorphic() ? LambdaToMethod.this.makePrivateSyntheticMethod(jCMemberReference.sym.flags(), jCMemberReference.sym.name, this.bridgedRefSig(), jCMemberReference.sym.enclClass()) : null;
            }

            int referenceKind() {
                return LambdaToMethod.this.referenceKind(((JCTree.JCMemberReference)this.tree).sym);
            }

            boolean needsVarArgsConversion() {
                return ((JCTree.JCMemberReference)this.tree).varargsElement != null;
            }

            boolean isArrayOp() {
                return ((JCTree.JCMemberReference)this.tree).sym.owner == ((LambdaToMethod)LambdaToMethod.this).syms.arrayClass;
            }

            boolean receiverAccessible() {
                return ((JCTree.JCMemberReference)this.tree).ownerAccessible;
            }

            boolean isPrivateInOtherClass() {
                return (((JCTree.JCMemberReference)this.tree).sym.flags() & 2L) != 0L && !LambdaToMethod.this.types.isSameType(LambdaToMethod.this.types.erasure((Type)((JCTree.JCMemberReference)this.tree).sym.enclClass().asType()), LambdaToMethod.this.types.erasure((Type)this.owner.enclClass().asType()));
            }

            boolean isProtectedInSuperClassOfEnclosingClassInOtherPackage() {
                return (((JCTree.JCMemberReference)this.tree).sym.flags() & 4L) != 0L && ((JCTree.JCMemberReference)this.tree).sym.packge() != this.owner.packge() && !this.owner.enclClass().isSubClass(((JCTree.JCMemberReference)this.tree).sym.owner, LambdaToMethod.this.types);
            }

            final boolean isSignaturePolymorphic() {
                return ((JCTree.JCMemberReference)this.tree).sym.kind == Kinds.Kind.MTH && LambdaToMethod.this.types.isSignaturePolymorphic((Symbol.MethodSymbol)((JCTree.JCMemberReference)this.tree).sym);
            }

            boolean interfaceParameterIsIntersectionType() {
                List<Type> list = ((JCTree.JCMemberReference)this.tree).getDescriptorType(LambdaToMethod.this.types).getParameterTypes();
                while (list.nonEmpty()) {
                    Type type = (Type)list.head;
                    if (type.getKind() == TypeKind.TYPEVAR) {
                        Type.TypeVar typeVar = (Type.TypeVar)type;
                        if (typeVar.bound.getKind() == TypeKind.INTERSECTION) {
                            return true;
                        }
                    }
                    list = list.tail;
                }
                return false;
            }

            final boolean needsConversionToLambda() {
                return this.interfaceParameterIsIntersectionType() || this.isSuper || this.needsVarArgsConversion() || this.isArrayOp() || this.isPrivateInOtherClass() || this.isProtectedInSuperClassOfEnclosingClassInOtherPackage() || !this.receiverAccessible() || ((JCTree.JCMemberReference)this.tree).getMode() == MemberReferenceTree.ReferenceMode.NEW && ((JCTree.JCMemberReference)this.tree).kind != JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR && (((JCTree.JCMemberReference)this.tree).sym.owner.isLocal() || ((JCTree.JCMemberReference)this.tree).sym.owner.isInner());
            }

            Type generatedRefSig() {
                return LambdaToMethod.this.types.erasure(((JCTree.JCMemberReference)this.tree).sym.type);
            }

            Type bridgedRefSig() {
                return LambdaToMethod.this.types.erasure(((LambdaToMethod)LambdaToMethod.this).types.findDescriptorSymbol((Symbol.TypeSymbol)((Type)((JCTree.JCMemberReference)this.tree).targets.head).tsym).type);
            }
        }

        class LambdaTranslationContext
        extends TranslationContext<JCTree.JCLambda> {
            final Symbol self;
            final Symbol assignedTo;
            Map<LambdaSymbolKind, Map<Symbol, Symbol>> translatedSymbols;
            Symbol.MethodSymbol translatedSym;
            List<JCTree.JCVariableDecl> syntheticParams;
            final Set<Symbol> freeVarProcessedLocalClasses;
            JCTree.JCExpression methodReferenceReceiver;

            LambdaTranslationContext(JCTree.JCLambda jCLambda) {
                super(LambdaAnalyzerPreprocessor.this, (JCTree.JCFunctionalExpression)jCLambda);
                Frame frame = (Frame)((LambdaAnalyzerPreprocessor)LambdaAnalyzerPreprocessor.this).frameStack.head;
                switch (frame.tree.getTag()) {
                    case VARDEF: {
                        this.assignedTo = this.self = ((JCTree.JCVariableDecl)frame.tree).sym;
                        break;
                    }
                    case ASSIGN: {
                        this.self = null;
                        this.assignedTo = TreeInfo.symbol(((JCTree.JCAssign)frame.tree).getVariable());
                        break;
                    }
                    default: {
                        this.self = null;
                        this.assignedTo = null;
                    }
                }
                this.translatedSym = LambdaToMethod.this.makePrivateSyntheticMethod(0L, null, null, this.owner.enclClass());
                this.translatedSymbols = new EnumMap<LambdaSymbolKind, Map<Symbol, Symbol>>(LambdaSymbolKind.class);
                this.translatedSymbols.put(LambdaSymbolKind.PARAM, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.LOCAL_VAR, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.CAPTURED_VAR, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.CAPTURED_THIS, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.CAPTURED_OUTER_THIS, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.TYPE_VAR, new LinkedHashMap());
                this.freeVarProcessedLocalClasses = new HashSet<Symbol>();
            }

            private String serializedLambdaDisambiguation() {
                StringBuilder stringBuilder = new StringBuilder();
                Assert.check(this.owner.type != null || LambdaAnalyzerPreprocessor.this.directlyEnclosingLambda() != null);
                if (this.owner.type != null) {
                    stringBuilder.append(LambdaToMethod.this.typeSig(this.owner.type));
                    stringBuilder.append(":");
                }
                stringBuilder.append(((LambdaToMethod)LambdaToMethod.this).types.findDescriptorSymbol((Symbol.TypeSymbol)((JCTree.JCLambda)this.tree).type.tsym).owner.flatName());
                stringBuilder.append(" ");
                if (this.assignedTo != null) {
                    stringBuilder.append(this.assignedTo.flatName());
                    stringBuilder.append("=");
                }
                for (Symbol symbol : this.getSymbolMap(LambdaSymbolKind.CAPTURED_VAR).keySet()) {
                    if (symbol == this.self) continue;
                    stringBuilder.append(LambdaToMethod.this.typeSig(symbol.type));
                    stringBuilder.append(" ");
                    stringBuilder.append(symbol.flatName());
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }

            private Name lambdaName() {
                return ((LambdaToMethod)LambdaToMethod.this).names.lambda.append(LambdaToMethod.this.names.fromString(this.enclosingMethodName() + "$" + LambdaAnalyzerPreprocessor.this.lambdaCount++));
            }

            private Name serializedLambdaName() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(((LambdaToMethod)LambdaToMethod.this).names.lambda);
                stringBuilder.append(this.enclosingMethodName());
                stringBuilder.append('$');
                String string = this.serializedLambdaDisambiguation();
                stringBuilder.append(Integer.toHexString(string.hashCode()));
                stringBuilder.append('$');
                stringBuilder.append(LambdaAnalyzerPreprocessor.this.syntheticMethodNameCounts.getIndex(stringBuilder));
                String string2 = stringBuilder.toString();
                return LambdaToMethod.this.names.fromString(string2);
            }

            Symbol translate(final Symbol symbol, LambdaSymbolKind lambdaSymbolKind) {
                Symbol symbol2;
                switch (lambdaSymbolKind) {
                    case CAPTURED_THIS: {
                        symbol2 = symbol;
                        break;
                    }
                    case TYPE_VAR: {
                        symbol2 = new Symbol.VarSymbol(symbol.flags(), symbol.name, LambdaToMethod.this.types.erasure(symbol.type), symbol.owner);
                        ((Symbol.VarSymbol)symbol2).pos = ((Symbol.VarSymbol)symbol).pos;
                        break;
                    }
                    case CAPTURED_VAR: {
                        symbol2 = new Symbol.VarSymbol(0x200001010L, symbol.name, LambdaToMethod.this.types.erasure(symbol.type), this.translatedSym){

                            @Override
                            public Symbol baseSymbol() {
                                return symbol;
                            }
                        };
                        break;
                    }
                    case CAPTURED_OUTER_THIS: {
                        Name name = LambdaToMethod.this.names.fromString(new String(symbol.flatName().toString().replace('.', '$') + ((LambdaToMethod)LambdaToMethod.this).names.dollarThis));
                        symbol2 = new Symbol.VarSymbol(0x200001010L, name, LambdaToMethod.this.types.erasure(symbol.type), this.translatedSym){

                            @Override
                            public Symbol baseSymbol() {
                                return symbol;
                            }
                        };
                        break;
                    }
                    case LOCAL_VAR: {
                        symbol2 = new Symbol.VarSymbol(symbol.flags() & 0x10L, symbol.name, symbol.type, this.translatedSym);
                        ((Symbol.VarSymbol)symbol2).pos = ((Symbol.VarSymbol)symbol).pos;
                        break;
                    }
                    case PARAM: {
                        symbol2 = new Symbol.VarSymbol(symbol.flags() & 0x10L | 0x200000000L, symbol.name, LambdaToMethod.this.types.erasure(symbol.type), this.translatedSym);
                        ((Symbol.VarSymbol)symbol2).pos = ((Symbol.VarSymbol)symbol).pos;
                        break;
                    }
                    default: {
                        Assert.error(lambdaSymbolKind.name());
                        throw new AssertionError();
                    }
                }
                if (symbol2 != symbol) {
                    symbol2.setDeclarationAttributes(symbol.getRawAttributes());
                    symbol2.setTypeAttributes(symbol.getRawTypeAttributes());
                }
                return symbol2;
            }

            void addSymbol(Symbol symbol, LambdaSymbolKind lambdaSymbolKind) {
                Object object;
                if (lambdaSymbolKind == LambdaSymbolKind.CAPTURED_THIS && symbol != null && symbol.kind == Kinds.Kind.TYP && !LambdaAnalyzerPreprocessor.this.typesUnderConstruction.isEmpty() && (object = LambdaAnalyzerPreprocessor.this.currentClass()) != null && LambdaAnalyzerPreprocessor.this.typesUnderConstruction.contains(object)) {
                    Assert.check(symbol != object);
                    lambdaSymbolKind = LambdaSymbolKind.CAPTURED_OUTER_THIS;
                }
                if (!(object = this.getSymbolMap(lambdaSymbolKind)).containsKey(symbol)) {
                    object.put((Symbol)symbol, (Symbol)this.translate(symbol, lambdaSymbolKind));
                }
            }

            Map<Symbol, Symbol> getSymbolMap(LambdaSymbolKind lambdaSymbolKind) {
                Map<Symbol, Symbol> map = this.translatedSymbols.get((Object)lambdaSymbolKind);
                Assert.checkNonNull(map);
                return map;
            }

            JCTree translate(JCTree.JCIdent jCIdent) {
                block3: for (LambdaSymbolKind lambdaSymbolKind : LambdaSymbolKind.values()) {
                    Map<Symbol, Symbol> map = this.getSymbolMap(lambdaSymbolKind);
                    switch (lambdaSymbolKind) {
                        default: {
                            if (!map.containsKey(jCIdent.sym)) continue block3;
                            Symbol symbol = map.get(jCIdent.sym);
                            JCTree.JCExpression jCExpression = LambdaToMethod.this.make.Ident(symbol).setType(jCIdent.type);
                            symbol.setTypeAttributes(jCIdent.sym.getRawTypeAttributes());
                            return jCExpression;
                        }
                        case CAPTURED_OUTER_THIS: {
                            if (jCIdent.sym.owner.kind != Kinds.Kind.TYP || !map.containsKey(jCIdent.sym.owner)) continue block3;
                            Symbol symbol = map.get(jCIdent.sym.owner);
                            JCTree.JCExpression jCExpression = LambdaToMethod.this.make.Ident(symbol).setType(jCIdent.sym.owner.type);
                            symbol.setTypeAttributes(jCIdent.sym.owner.getRawTypeAttributes());
                            jCExpression = LambdaToMethod.this.make.Select(jCExpression, jCIdent.name);
                            jCExpression.setType(jCIdent.type);
                            TreeInfo.setSymbol(jCExpression, jCIdent.sym);
                            return jCExpression;
                        }
                    }
                }
                return null;
            }

            public JCTree translate(JCTree.JCFieldAccess jCFieldAccess) {
                Assert.check(jCFieldAccess.name == ((LambdaToMethod)LambdaToMethod.this).names._this);
                Map<Symbol, Symbol> map = this.translatedSymbols.get((Object)LambdaSymbolKind.CAPTURED_OUTER_THIS);
                if (map.containsKey(jCFieldAccess.sym.owner)) {
                    Symbol symbol = map.get(jCFieldAccess.sym.owner);
                    JCTree.JCExpression jCExpression = LambdaToMethod.this.make.Ident(symbol).setType(jCFieldAccess.sym.owner.type);
                    symbol.setTypeAttributes(jCFieldAccess.sym.owner.getRawTypeAttributes());
                    return jCExpression;
                }
                return null;
            }

            void complete() {
                if (this.syntheticParams != null) {
                    return;
                }
                boolean bl = this.translatedSym.owner.isInterface();
                boolean bl2 = !this.getSymbolMap(LambdaSymbolKind.CAPTURED_THIS).isEmpty();
                this.translatedSym.flags_field = 0x2000000001000L | this.owner.flags_field & 0x800L | this.owner.owner.flags_field & 0x800L | 2L | (bl2 ? (bl ? 0x80000000000L : 0L) : 8L);
                ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
                ListBuffer<Symbol.VarSymbol> listBuffer2 = new ListBuffer<Symbol.VarSymbol>();
                for (Symbol symbol : this.getSymbolMap(LambdaSymbolKind.CAPTURED_VAR).values()) {
                    listBuffer.append(LambdaToMethod.this.make.VarDef((Symbol.VarSymbol)symbol, null));
                    listBuffer2.append((Symbol.VarSymbol)symbol);
                }
                for (Symbol symbol : this.getSymbolMap(LambdaSymbolKind.CAPTURED_OUTER_THIS).values()) {
                    listBuffer.append(LambdaToMethod.this.make.VarDef((Symbol.VarSymbol)symbol, null));
                    listBuffer2.append((Symbol.VarSymbol)symbol);
                }
                for (Symbol symbol : this.getSymbolMap(LambdaSymbolKind.PARAM).values()) {
                    listBuffer.append(LambdaToMethod.this.make.VarDef((Symbol.VarSymbol)symbol, null));
                    listBuffer2.append((Symbol.VarSymbol)symbol);
                }
                this.syntheticParams = listBuffer.toList();
                this.translatedSym.params = listBuffer2.toList();
                this.translatedSym.name = this.isSerializable() ? this.serializedLambdaName() : this.lambdaName();
                this.translatedSym.type = LambdaToMethod.this.types.createMethodTypeWithParameters(this.generatedLambdaSig(), TreeInfo.types(this.syntheticParams));
            }

            Type generatedLambdaSig() {
                return LambdaToMethod.this.types.erasure(((JCTree.JCLambda)this.tree).getDescriptorType(LambdaToMethod.this.types));
            }
        }

        static abstract class TranslationContext<T extends JCTree.JCFunctionalExpression> {
            final T tree;
            final Symbol owner;
            final int depth;
            final TranslationContext<?> prev;
            final List<Symbol> bridges;
            final /* synthetic */ LambdaAnalyzerPreprocessor this$1;

            TranslationContext(T t) {
                this.this$1 = var1_1;
                this.tree = t;
                this.owner = ((LambdaAnalyzerPreprocessor)var1_1).owner(true);
                this.depth = ((LambdaAnalyzerPreprocessor)var1_1).frameStack.size() - 1;
                this.prev = ((LambdaAnalyzerPreprocessor)var1_1).context();
                Symbol.ClassSymbol classSymbol = var1_1.LambdaToMethod.this.types.makeFunctionalInterfaceClass(var1_1.LambdaToMethod.this.attrEnv, ((LambdaToMethod)var1_1.LambdaToMethod.this).names.empty, ((JCTree.JCFunctionalExpression)t).targets, 1536L);
                this.bridges = var1_1.LambdaToMethod.this.types.functionalInterfaceBridges(classSymbol);
            }

            boolean needsAltMetafactory() {
                return ((JCTree.JCFunctionalExpression)this.tree).targets.length() > 1 || this.isSerializable() || this.bridges.length() > 1;
            }

            boolean isSerializable() {
                if (this.this$1.LambdaToMethod.this.forceSerializable) {
                    return true;
                }
                for (Type type : ((JCTree.JCFunctionalExpression)this.tree).targets) {
                    if (this.this$1.LambdaToMethod.this.types.asSuper(type, ((LambdaToMethod)this.this$1.LambdaToMethod.this).syms.serializableType.tsym) == null) continue;
                    return true;
                }
                return false;
            }

            String enclosingMethodName() {
                return this.syntheticMethodNameComponent(this.owner.name);
            }

            String syntheticMethodNameComponent(Name name) {
                if (name == null) {
                    return "null";
                }
                String string = name.toString();
                if (string.equals("<clinit>")) {
                    string = "static";
                } else if (string.equals("<init>")) {
                    string = "new";
                }
                return string;
            }
        }

        private class Frame {
            final JCTree tree;
            List<Symbol> locals;

            public Frame(JCTree jCTree) {
                this.tree = jCTree;
            }

            void addLocal(Symbol symbol) {
                if (this.locals == null) {
                    this.locals = List.nil();
                }
                this.locals = this.locals.prepend(symbol);
            }
        }

        private class SyntheticMethodNameCounter {
            private Map<String, Integer> map = new HashMap<String, Integer>();

            private SyntheticMethodNameCounter() {
            }

            int getIndex(StringBuilder stringBuilder) {
                String string = stringBuilder.toString();
                Integer n = this.map.get(string);
                if (n == null) {
                    n = 0;
                }
                n = n + 1;
                this.map.put(string, n);
                return n;
            }
        }
    }

    private class MemberReferenceToLambda {
        private final JCTree.JCMemberReference tree;
        private final LambdaAnalyzerPreprocessor.ReferenceTranslationContext localContext;
        private final Symbol owner;
        private final ListBuffer<JCTree.JCExpression> args = new ListBuffer();
        private final ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer();
        private JCTree.JCExpression receiverExpression = null;

        MemberReferenceToLambda(JCTree.JCMemberReference jCMemberReference, LambdaAnalyzerPreprocessor.ReferenceTranslationContext referenceTranslationContext, Symbol symbol) {
            this.tree = jCMemberReference;
            this.localContext = referenceTranslationContext;
            this.owner = symbol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JCTree.JCLambda lambda() {
            int n = ((LambdaToMethod)LambdaToMethod.this).make.pos;
            try {
                LambdaToMethod.this.make.at(this.tree);
                Symbol.VarSymbol varSymbol = this.addParametersReturnReceiver();
                JCTree.JCExpression jCExpression = this.tree.getMode() == MemberReferenceTree.ReferenceMode.INVOKE ? this.expressionInvoke(varSymbol) : this.expressionNew();
                JCTree.JCLambda jCLambda = LambdaToMethod.this.make.Lambda(this.params.toList(), jCExpression);
                jCLambda.targets = this.tree.targets;
                jCLambda.type = this.tree.type;
                jCLambda.pos = this.tree.pos;
                JCTree.JCLambda jCLambda2 = jCLambda;
                return jCLambda2;
            }
            finally {
                LambdaToMethod.this.make.at(n);
            }
        }

        Symbol.VarSymbol addParametersReturnReceiver() {
            int n;
            Symbol.VarSymbol varSymbol;
            Type type = this.localContext.bridgedRefSig();
            List<Type> list = type.getParameterTypes();
            List<Type> list2 = this.tree.getDescriptorType(LambdaToMethod.this.types).getParameterTypes();
            switch (this.tree.kind) {
                case BOUND: {
                    varSymbol = this.addParameter("rec$", this.tree.getQualifierExpression().type, false);
                    this.receiverExpression = LambdaToMethod.this.attr.makeNullCheck(this.tree.getQualifierExpression());
                    break;
                }
                case UNBOUND: {
                    varSymbol = this.addParameter("rec$", (Type)type.getParameterTypes().head, false);
                    list = list.tail;
                    list2 = list2.tail;
                    break;
                }
                default: {
                    varSymbol = null;
                }
            }
            List<Type> list3 = this.tree.sym.type.getParameterTypes();
            int n2 = list3.size();
            int n3 = list.size();
            int n4 = this.localContext.needsVarArgsConversion() ? n2 - 1 : n2;
            boolean bl = this.tree.varargsElement != null || n2 == list2.size();
            for (n = 0; list3.nonEmpty() && n < n4; ++n) {
                Type type2 = (Type)list3.head;
                if (bl && ((Type)list2.head).getKind() == TypeKind.TYPEVAR) {
                    Type.TypeVar typeVar = (Type.TypeVar)list2.head;
                    if (typeVar.bound.getKind() == TypeKind.INTERSECTION) {
                        type2 = (Type)list.head;
                    }
                }
                this.addParameter("x$" + n, type2, true);
                list3 = list3.tail;
                list = list.tail;
                list2 = list2.tail;
            }
            for (n = n4; n < n3; ++n) {
                this.addParameter("xva$" + n, this.tree.varargsElement, true);
            }
            return varSymbol;
        }

        JCTree.JCExpression getReceiverExpression() {
            return this.receiverExpression;
        }

        private JCTree.JCExpression makeReceiver(Symbol.VarSymbol varSymbol) {
            Type type;
            if (varSymbol == null) {
                return null;
            }
            JCTree.JCExpression jCExpression = LambdaToMethod.this.make.Ident(varSymbol);
            Type type2 = type = this.tree.ownerAccessible ? this.tree.sym.enclClass().type : this.tree.expr.type;
            if (type == ((LambdaToMethod)LambdaToMethod.this).syms.arrayClass.type) {
                type = this.tree.getQualifierExpression().type;
            }
            if (!varSymbol.type.tsym.isSubClass(type.tsym, LambdaToMethod.this.types)) {
                jCExpression = LambdaToMethod.this.make.TypeCast(LambdaToMethod.this.make.Type(type), jCExpression).setType(type);
            }
            return jCExpression;
        }

        private JCTree.JCExpression expressionInvoke(Symbol.VarSymbol varSymbol) {
            JCTree.JCExpression jCExpression = varSymbol != null ? this.makeReceiver(varSymbol) : this.tree.getQualifierExpression();
            JCTree.JCFieldAccess jCFieldAccess = LambdaToMethod.this.make.Select(jCExpression, this.tree.sym.name);
            jCFieldAccess.sym = this.tree.sym;
            jCFieldAccess.type = this.tree.sym.erasure(LambdaToMethod.this.types);
            JCTree.JCExpression jCExpression2 = LambdaToMethod.this.make.Apply(List.nil(), jCFieldAccess, LambdaToMethod.this.convertArgs(this.tree.sym, this.args.toList(), this.tree.varargsElement)).setType(this.tree.sym.erasure(LambdaToMethod.this.types).getReturnType());
            jCExpression2 = LambdaToMethod.this.transTypes.coerce(LambdaToMethod.this.attrEnv, jCExpression2, LambdaToMethod.this.types.erasure(((JCTree.JCMemberReference)this.localContext.tree).referentType.getReturnType()));
            LambdaToMethod.this.setVarargsIfNeeded(jCExpression2, this.tree.varargsElement);
            return jCExpression2;
        }

        private JCTree.JCExpression expressionNew() {
            if (this.tree.kind == JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR) {
                JCTree.JCNewArray jCNewArray = LambdaToMethod.this.make.NewArray(LambdaToMethod.this.make.Type(LambdaToMethod.this.types.elemtype(this.tree.getQualifierExpression().type)), List.of(LambdaToMethod.this.make.Ident(this.params.first())), null);
                jCNewArray.type = this.tree.getQualifierExpression().type;
                return jCNewArray;
            }
            JCTree.JCNewClass jCNewClass = LambdaToMethod.this.make.NewClass(null, List.nil(), LambdaToMethod.this.make.Type(this.tree.getQualifierExpression().type), LambdaToMethod.this.convertArgs(this.tree.sym, this.args.toList(), this.tree.varargsElement), null);
            jCNewClass.constructor = this.tree.sym;
            jCNewClass.constructorType = this.tree.sym.erasure(LambdaToMethod.this.types);
            jCNewClass.type = this.tree.getQualifierExpression().type;
            LambdaToMethod.this.setVarargsIfNeeded(jCNewClass, this.tree.varargsElement);
            return jCNewClass;
        }

        private Symbol.VarSymbol addParameter(String string, Type type, boolean bl) {
            Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0x200001000L, LambdaToMethod.this.names.fromString(string), type, this.owner);
            varSymbol.pos = this.tree.pos;
            this.params.append(LambdaToMethod.this.make.VarDef(varSymbol, null));
            if (bl) {
                this.args.append(LambdaToMethod.this.make.Ident(varSymbol));
            }
            return varSymbol;
        }
    }

    private class KlassInfo {
        private ListBuffer<JCTree> appendedMethodList;
        private final Map<String, ListBuffer<JCTree.JCStatement>> deserializeCases;
        private final Symbol.MethodSymbol deserMethodSym;
        private final Symbol.VarSymbol deserParamSym;
        private final JCTree.JCClassDecl clazz;

        private KlassInfo(JCTree.JCClassDecl jCClassDecl) {
            this.clazz = jCClassDecl;
            this.appendedMethodList = new ListBuffer();
            this.deserializeCases = new HashMap<String, ListBuffer<JCTree.JCStatement>>();
            Type.MethodType methodType = new Type.MethodType(List.of(((LambdaToMethod)LambdaToMethod.this).syms.serializedLambdaType), ((LambdaToMethod)LambdaToMethod.this).syms.objectType, List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.methodClass);
            this.deserMethodSym = LambdaToMethod.this.makePrivateSyntheticMethod(8L, ((LambdaToMethod)LambdaToMethod.this).names.deserializeLambda, methodType, jCClassDecl.sym);
            this.deserParamSym = new Symbol.VarSymbol(16L, LambdaToMethod.this.names.fromString("lambda"), ((LambdaToMethod)LambdaToMethod.this).syms.serializedLambdaType, this.deserMethodSym);
        }

        private void addMethod(JCTree jCTree) {
            this.appendedMethodList = this.appendedMethodList.prepend(jCTree);
        }
    }
}

