/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.google.errorprone.names.NamingConventions;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;

class EnclosedByReverseHeuristic
implements Heuristic {
    private static final ImmutableSet<String> DEFAULT_REVERSE_WORDS_TERMS = ImmutableSet.of((Object)"backward", (Object)"backwards", (Object)"complement", (Object)"endian", (Object)"flip", (Object)"inverse", (Object[])new String[]{"invert", "landscape", "opposite", "portrait", "reciprocal", "reverse", "reversed", "rotate", "rotated", "rotation", "swap", "swapped", "transpose", "transposed", "undo"});
    private final ImmutableSet<String> reverseWordsTerms;

    EnclosedByReverseHeuristic() {
        this(DEFAULT_REVERSE_WORDS_TERMS);
    }

    EnclosedByReverseHeuristic(ImmutableSet<String> reverseWordsTerms) {
        this.reverseWordsTerms = reverseWordsTerms;
    }

    @Override
    public boolean isAcceptableChange(Changes changes, Tree node, Symbol.MethodSymbol symbol, VisitorState state) {
        return this.findReverseWordsMatchInParentNodes(state) == null;
    }

    protected String findReverseWordsMatchInParentNodes(VisitorState state) {
        for (Tree tree : state.getPath()) {
            Optional<String> name = EnclosedByReverseHeuristic.getName(tree);
            if (!name.isPresent()) continue;
            for (String term : NamingConventions.splitToLowercaseTerms((String)name.get())) {
                if (!this.reverseWordsTerms.contains((Object)term)) continue;
                return term;
            }
        }
        return null;
    }

    private static Optional<String> getName(Tree tree) {
        if (tree instanceof MethodTree) {
            return Optional.of(((MethodTree)tree).getName().toString());
        }
        if (tree instanceof ClassTree) {
            return Optional.of(((ClassTree)tree).getSimpleName().toString());
        }
        return Optional.empty();
    }
}

