/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import lombok.ast.Node;

public final class Position {
    private final int start;
    private final int end;
    private final Node generatedBy;
    public static Position UNPLACED = new Position(-1, -1);

    public Position(int start, int end) {
        this.start = start;
        this.end = end;
        this.generatedBy = null;
    }

    public Position(int start, int end, Node generatedBy) {
        this.start = start;
        this.end = end;
        this.generatedBy = generatedBy;
    }

    public int size() {
        return this.end - this.start;
    }

    public boolean isUnplaced() {
        return this.start == Position.UNPLACED.start && this.end == Position.UNPLACED.end;
    }

    public Position withGeneratedBy(Node generatedBy) {
        return new Position(this.start, this.end, generatedBy);
    }

    public Position withoutGeneratedBy() {
        return new Position(this.start, this.end);
    }

    public Position withEnd(int position) {
        return new Position(this.start, position, this.generatedBy);
    }

    public Position withStart(int position) {
        return new Position(position, this.end, this.generatedBy);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public Node getGeneratedBy() {
        return this.generatedBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        return !(this.getGeneratedBy() == null ? other.getGeneratedBy() != null : !this.getGeneratedBy().equals(other.getGeneratedBy()));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.getStart();
        result = result * 31 + this.getEnd();
        result = result * 31 + (this.getGeneratedBy() == null ? 0 : this.getGeneratedBy().hashCode());
        return result;
    }

    public String toString() {
        return "Position(start=" + this.getStart() + ", end=" + this.getEnd() + ", generatedBy=" + this.getGeneratedBy() + ")";
    }
}

