/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.DerivedCollectionGenerators;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.SortedSetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestSortedSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.testers.NavigableSetNavigationTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import junit.framework.TestSuite;

@GwtIncompatible
public final class NavigableSetTestSuiteBuilder<E>
extends SortedSetTestSuiteBuilder<E> {
    public static <E> NavigableSetTestSuiteBuilder<E> using(TestSortedSetGenerator<E> generator) {
        NavigableSetTestSuiteBuilder<E> builder = new NavigableSetTestSuiteBuilder<E>();
        builder.usingGenerator(generator);
        return builder;
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder) {
        ArrayList<TestSuite> derivedSuites = new ArrayList<TestSuite>(super.createDerivedSuites(parentBuilder));
        if (!parentBuilder.getFeatures().contains(CollectionFeature.SUBSET_VIEW)) {
            derivedSuites.add(this.createSubsetSuite(parentBuilder, DerivedCollectionGenerators.Bound.NO_BOUND, DerivedCollectionGenerators.Bound.INCLUSIVE));
            derivedSuites.add(this.createSubsetSuite(parentBuilder, DerivedCollectionGenerators.Bound.EXCLUSIVE, DerivedCollectionGenerators.Bound.NO_BOUND));
            derivedSuites.add(this.createSubsetSuite(parentBuilder, DerivedCollectionGenerators.Bound.EXCLUSIVE, DerivedCollectionGenerators.Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubsetSuite(parentBuilder, DerivedCollectionGenerators.Bound.EXCLUSIVE, DerivedCollectionGenerators.Bound.INCLUSIVE));
            derivedSuites.add(this.createSubsetSuite(parentBuilder, DerivedCollectionGenerators.Bound.INCLUSIVE, DerivedCollectionGenerators.Bound.INCLUSIVE));
        }
        if (!parentBuilder.getFeatures().contains(CollectionFeature.DESCENDING_VIEW)) {
            derivedSuites.add(this.createDescendingSuite(parentBuilder));
        }
        return derivedSuites;
    }

    @Override
    public NavigableSetTestSuiteBuilder<E> newBuilderUsing(TestSortedSetGenerator<E> delegate, DerivedCollectionGenerators.Bound to, DerivedCollectionGenerators.Bound from) {
        return NavigableSetTestSuiteBuilder.using(new NavigableSetSubsetTestSetGenerator<E>(delegate, to, from));
    }

    private TestSuite createDescendingSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder) {
        final TestSetGenerator delegate = (TestSetGenerator)parentBuilder.getSubjectGenerator().getInnerGenerator();
        ArrayList features = new ArrayList();
        features.add(CollectionFeature.DESCENDING_VIEW);
        features.addAll(parentBuilder.getFeatures());
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using(new TestSetGenerator<E>(){

            @Override
            public SampleElements<E> samples() {
                return delegate.samples();
            }

            @Override
            public E[] createArray(int length) {
                return delegate.createArray(length);
            }

            @Override
            public Iterable<E> order(List<E> insertionOrder) {
                ArrayList list = new ArrayList();
                for (Object e : delegate.order(insertionOrder)) {
                    list.add(e);
                }
                Collections.reverse(list);
                return list;
            }

            @Override
            public Set<E> create(Object ... elements) {
                NavigableSet navigableSet = (NavigableSet)delegate.create(elements);
                return navigableSet.descendingSet();
            }
        }).named(parentBuilder.getName() + " descending")).withFeatures(features)).suppressing(parentBuilder.getSuppressedTests())).createTestSuite();
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(NavigableSetNavigationTester.class);
        return testers;
    }

    public static final class NavigableSetSubsetTestSetGenerator<E>
    extends DerivedCollectionGenerators.SortedSetSubsetTestSetGenerator<E> {
        public NavigableSetSubsetTestSetGenerator(TestSortedSetGenerator<E> delegate, DerivedCollectionGenerators.Bound to, DerivedCollectionGenerators.Bound from) {
            super(delegate, to, from);
        }

        @Override
        NavigableSet<E> createSubSet(SortedSet<E> sortedSet, E firstExclusive, E lastExclusive) {
            NavigableSet set = (NavigableSet)sortedSet;
            if (this.from == DerivedCollectionGenerators.Bound.NO_BOUND && this.to == DerivedCollectionGenerators.Bound.INCLUSIVE) {
                return set.headSet(this.lastInclusive, true);
            }
            if (this.from == DerivedCollectionGenerators.Bound.EXCLUSIVE && this.to == DerivedCollectionGenerators.Bound.NO_BOUND) {
                return set.tailSet(firstExclusive, false);
            }
            if (this.from == DerivedCollectionGenerators.Bound.EXCLUSIVE && this.to == DerivedCollectionGenerators.Bound.EXCLUSIVE) {
                return set.subSet(firstExclusive, false, lastExclusive, false);
            }
            if (this.from == DerivedCollectionGenerators.Bound.EXCLUSIVE && this.to == DerivedCollectionGenerators.Bound.INCLUSIVE) {
                return set.subSet(firstExclusive, false, this.lastInclusive, true);
            }
            if (this.from == DerivedCollectionGenerators.Bound.INCLUSIVE && this.to == DerivedCollectionGenerators.Bound.INCLUSIVE) {
                return set.subSet(this.firstInclusive, true, this.lastInclusive, true);
            }
            return (NavigableSet)super.createSubSet(set, firstExclusive, lastExclusive);
        }
    }
}

