/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(name="InjectedConstructorAnnotations", summary="Injected constructors cannot be optional nor have binding annotations", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class InjectedConstructorAnnotations
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<AnnotationTree> OPTIONAL_INJECTION_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isType((String)"com.google.inject.Inject"), Matchers.hasArgumentWithValue((String)"optional", (Matcher)Matchers.booleanLiteral((boolean)true))});
    private static final Matcher<AnnotationTree> BINDING_ANNOTATION_MATCHER = new Matcher<AnnotationTree>(){

        public boolean matches(AnnotationTree annotationTree, VisitorState state) {
            return Matchers.symbolHasAnnotation((String)"com.google.inject.BindingAnnotation").matches(annotationTree.getAnnotationType(), state);
        }
    };

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        SuggestedFix.Builder fix = null;
        if (this.isInjectedConstructor(methodTree, state)) {
            for (AnnotationTree annotationTree : methodTree.getModifiers().getAnnotations()) {
                if (OPTIONAL_INJECTION_MATCHER.matches((Tree)annotationTree, state)) {
                    if (fix == null) {
                        fix = SuggestedFix.builder();
                    }
                    fix = fix.replace((Tree)annotationTree, "@Inject");
                    continue;
                }
                if (!BINDING_ANNOTATION_MATCHER.matches((Tree)annotationTree, state)) continue;
                if (fix == null) {
                    fix = SuggestedFix.builder();
                }
                fix = fix.delete((Tree)annotationTree);
            }
        }
        if (fix == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodTree, (Fix)fix.build());
    }

    private boolean isInjectedConstructor(MethodTree methodTree, VisitorState state) {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.hasAnnotation((String)"com.google.inject.Inject")}).matches((Tree)methodTree, state);
    }
}

