/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;

@BugPattern(name="MultiVariableDeclaration", summary="Variable declarations should declare only one variable", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, linkType=BugPattern.LinkType.CUSTOM, tags={"Style"}, link="https://google.github.io/styleguide/javaguide.html#s4.8.2.1-variables-per-declaration")
public class MultiVariableDeclaration
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.BlockTreeMatcher {
    public Description matchBlock(BlockTree tree, VisitorState state) {
        return this.checkDeclarations(tree.getStatements(), state);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        return this.checkDeclarations(tree.getMembers(), state);
    }

    private Description checkDeclarations(List<? extends Tree> children, VisitorState state) {
        PeekingIterator it = Iterators.peekingIterator(children.iterator());
        while (it.hasNext()) {
            if (((Tree)it.peek()).getKind() != Tree.Kind.VARIABLE) {
                it.next();
                continue;
            }
            VariableTree variableTree = (VariableTree)it.next();
            ArrayList<VariableTree> fragments = new ArrayList<VariableTree>();
            fragments.add(variableTree);
            while (it.hasNext() && ((Tree)it.peek()).getKind() == Tree.Kind.VARIABLE && ((JCTree)((Object)variableTree)).getStartPosition() == ((JCTree)it.peek()).getStartPosition()) {
                fragments.add((VariableTree)it.next());
            }
            if (fragments.size() == 1) continue;
            SuggestedFix fix = SuggestedFix.replace((int)((JCTree)fragments.get(0)).getStartPosition(), (int)state.getEndPosition((Tree)Iterables.getLast(fragments)), (String)(Joiner.on((String)"; ").join(fragments) + ";"));
            state.reportMatch(this.describeMatch((Tree)fragments.get(0), (Fix)fix));
        }
        return Description.NO_MATCH;
    }
}

