/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;

@BugPattern(name="DeadException", altNames={"ThrowableInstanceNeverThrown"}, summary="Exception created but not thrown", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class DeadException
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    public static final Matcher<Tree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.parentNode((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.EXPRESSION_STATEMENT)), Matchers.isSubtypeOf((Supplier)Suppliers.THROWABLE_TYPE), Matchers.not((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.enclosingClass((Matcher)JUnitMatchers.isJUnit3TestClass), Matchers.enclosingClass((Matcher)JUnitMatchers.isAmbiguousJUnitVersion), Matchers.enclosingClass((Matcher)JUnitMatchers.isJUnit4TestClass)}))});

    public Description matchNewClass(NewClassTree newClassTree, VisitorState state) {
        if (!MATCHER.matches((Tree)newClassTree, state)) {
            return Description.NO_MATCH;
        }
        StatementTree parent = (StatementTree)state.getPath().getParentPath().getLeaf();
        boolean isLastStatement = Matchers.anyOf((Matcher[])new Matcher[]{new ChildOfBlockOrCase(ChildMultiMatcher.MatchType.LAST, (Matcher<StatementTree>)Matchers.isSame((Tree)parent)), Matchers.parentNode((Matcher)Matchers.parentNode((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.IF)))}).matches((Tree)newClassTree, state);
        SuggestedFix fix = isLastStatement ? SuggestedFix.prefixWith((Tree)newClassTree, (String)"throw ") : SuggestedFix.delete((Tree)parent);
        return this.describeMatch(newClassTree, (Fix)fix);
    }

    private static class ChildOfBlockOrCase<T extends Tree>
    extends ChildMultiMatcher<T, StatementTree> {
        public ChildOfBlockOrCase(ChildMultiMatcher.MatchType matchType, Matcher<StatementTree> nodeMatcher) {
            super(matchType, nodeMatcher);
        }

        protected Iterable<? extends StatementTree> getChildNodes(T tree, VisitorState state) {
            Tree enclosing = state.findEnclosing(new Class[]{CaseTree.class, BlockTree.class});
            if (enclosing == null) {
                return ImmutableList.of();
            }
            if (enclosing instanceof BlockTree) {
                return ((BlockTree)enclosing).getStatements();
            }
            if (enclosing instanceof CaseTree) {
                return ((CaseTree)enclosing).getStatements();
            }
            throw new IllegalStateException("enclosing tree not a BlockTree or CaseTree");
        }
    }
}

