/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

public class IntHashTable {
    private static final int DEFAULT_INITIAL_SIZE = 64;
    protected Object[] objs;
    protected int[] ints;
    protected int mask;
    protected int num_bindings;
    private static final Object DELETED = new Object();

    public IntHashTable() {
        this.objs = new Object[64];
        this.ints = new int[64];
        this.mask = 63;
    }

    public IntHashTable(int n) {
        int n2 = 4;
        while (n > 1 << n2) {
            ++n2;
        }
        n = 1 << n2;
        this.objs = new Object[n];
        this.ints = new int[n];
        this.mask = n - 1;
    }

    public int hash(Object object) {
        return System.identityHashCode(object);
    }

    public int lookup(Object object, int n) {
        int n2 = n ^ n >>> 15;
        int n3 = n ^ n << 6 | 1;
        int n4 = -1;
        int n5 = n2 & this.mask;
        Object object2;
        while ((object2 = this.objs[n5]) != object) {
            if (object2 == null) {
                return n4 >= 0 ? n4 : n5;
            }
            if (object2 == DELETED && n4 < 0) {
                n4 = n5;
            }
            n5 = n5 + n3 & this.mask;
        }
        return n5;
    }

    public int lookup(Object object) {
        return this.lookup(object, this.hash(object));
    }

    public int getFromIndex(int n) {
        Object object = this.objs[n];
        return object == null || object == DELETED ? -1 : this.ints[n];
    }

    public int putAtIndex(Object object, int n, int n2) {
        Object object2 = this.objs[n2];
        if (object2 == null || object2 == DELETED) {
            this.objs[n2] = object;
            this.ints[n2] = n;
            if (object2 != DELETED) {
                ++this.num_bindings;
            }
            if (3 * this.num_bindings >= 2 * this.objs.length) {
                this.rehash();
            }
            return -1;
        }
        int n3 = this.ints[n2];
        this.ints[n2] = n;
        return n3;
    }

    public int remove(Object object) {
        int n = this.lookup(object);
        Object object2 = this.objs[n];
        if (object2 == null || object2 == DELETED) {
            return -1;
        }
        this.objs[n] = DELETED;
        return this.ints[n];
    }

    protected void rehash() {
        Object[] objectArray = this.objs;
        int[] nArray = this.ints;
        int n = objectArray.length;
        int n2 = n << 1;
        Object[] objectArray2 = new Object[n2];
        int[] nArray2 = new int[n2];
        int n3 = n2 - 1;
        this.objs = objectArray2;
        this.ints = nArray2;
        this.mask = n3;
        this.num_bindings = 0;
        int n4 = nArray.length;
        while (--n4 >= 0) {
            Object object = objectArray[n4];
            if (object == null || object == DELETED) continue;
            this.putAtIndex(object, nArray[n4], this.lookup(object, this.hash(object)));
        }
    }

    public void clear() {
        int n = this.objs.length;
        while (--n >= 0) {
            this.objs[n] = null;
        }
        this.num_bindings = 0;
    }
}

