/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.impl.InternalResponse;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.responses.Response;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class InvocationFuture<E>
implements InternalCompletableFuture<E> {
    private static final int MAX_CALL_TIMEOUT_EXTENSION = 60000;
    private static final AtomicReferenceFieldUpdater<InvocationFuture, Object> RESPONSE = AtomicReferenceFieldUpdater.newUpdater(InvocationFuture.class, Object.class, "response");
    private static final AtomicIntegerFieldUpdater<InvocationFuture> WAITER_COUNT = AtomicIntegerFieldUpdater.newUpdater(InvocationFuture.class, "waiterCount");
    volatile boolean interrupted;
    volatile Object response;
    final Invocation invocation;
    private volatile int waiterCount;
    private final OperationServiceImpl operationService;
    private volatile ExecutionCallbackNode<E> callbackHead;

    InvocationFuture(OperationServiceImpl operationService, Invocation invocation, ExecutionCallback callback) {
        this.invocation = invocation;
        this.operationService = operationService;
        if (callback != null) {
            this.callbackHead = new ExecutionCallbackNode(callback, operationService.asyncExecutor, null);
        }
    }

    static long decrementTimeout(long timeout, long diff) {
        if (timeout == Long.MAX_VALUE) {
            return timeout;
        }
        return timeout - diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andThen(ExecutionCallback<E> callback, Executor executor) {
        Preconditions.isNotNull(callback, "callback");
        Preconditions.isNotNull(executor, "executor");
        InvocationFuture invocationFuture = this;
        synchronized (invocationFuture) {
            if (this.responseAvailable(this.response)) {
                this.runAsynchronous(callback, executor);
                return;
            }
            this.callbackHead = new ExecutionCallbackNode(callback, executor, this.callbackHead);
        }
    }

    private boolean responseAvailable(Object response) {
        if (response == null) {
            return false;
        }
        return response != InternalResponse.WAIT_RESPONSE;
    }

    @Override
    public void andThen(ExecutionCallback<E> callback) {
        this.andThen(callback, (Executor)this.operationService.asyncExecutor);
    }

    private void runAsynchronous(final ExecutionCallback<E> callback, Executor executor) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object resp = InvocationFuture.this.resolveApplicationResponse(InvocationFuture.this.response);
                        if (resp == null || !(resp instanceof Throwable)) {
                            callback.onResponse(resp);
                        } else {
                            callback.onFailure((Throwable)resp);
                        }
                    }
                    catch (Throwable cause) {
                        InvocationFuture.this.invocation.logger.severe("Failed asynchronous execution of execution callback: " + callback + "for call " + InvocationFuture.this.invocation, cause);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.invocation.logger.warning("Execution of callback: " + callback + " is rejected!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(Object offeredResponse) {
        ExecutionCallbackNode<E> callbackChain;
        assert (!(offeredResponse instanceof Response)) : "unexpected response found: " + offeredResponse;
        if (offeredResponse == null) {
            offeredResponse = InternalResponse.NULL_RESPONSE;
        }
        InvocationFuture invocationFuture = this;
        synchronized (invocationFuture) {
            if (this.response != null && !(this.response instanceof InternalResponse)) {
                ILogger logger;
                if (this.response != offeredResponse && (logger = this.invocation.logger).isFinestEnabled()) {
                    logger.finest("Future response is already set! Current response: " + this.response + ", Offered response: " + offeredResponse + ", Invocation: " + this.invocation);
                }
                this.operationService.invocationsRegistry.deregister(this.invocation);
                return false;
            }
            this.response = offeredResponse;
            if (offeredResponse == InternalResponse.WAIT_RESPONSE) {
                return true;
            }
            callbackChain = this.callbackHead;
            this.callbackHead = null;
            this.notifyAll();
            this.operationService.invocationsRegistry.deregister(this.invocation);
        }
        this.notifyCallbacks(callbackChain);
        return true;
    }

    private void notifyCallbacks(ExecutionCallbackNode<E> callbackChain) {
        while (callbackChain != null) {
            this.runAsynchronous(callbackChain.callback, callbackChain.executor);
            callbackChain = callbackChain.next;
        }
    }

    @Override
    public E get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.invocation.logger.severe("Unexpected timeout while processing " + this, e);
            return null;
        }
    }

    @Override
    public E getSafely() {
        try {
            return this.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public E get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object unresolvedResponse = this.waitForResponse(timeout, unit);
        return (E)this.resolveApplicationResponseOrThrowException(unresolvedResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object waitForResponse(long time, TimeUnit unit) {
        if (this.responseAvailable(this.response)) {
            return this.response;
        }
        WAITER_COUNT.incrementAndGet(this);
        try {
            long timeoutMs = InvocationFuture.toTimeoutMs(time, unit);
            long maxCallTimeoutMs = this.getMaxCallTimeout();
            boolean longPolling = timeoutMs > maxCallTimeoutMs;
            int pollCount = 0;
            while (timeoutMs >= 0L) {
                long pollTimeoutMs = Math.min(maxCallTimeoutMs, timeoutMs);
                long startMs = Clock.currentTimeMillis();
                long lastPollTime = 0L;
                ++pollCount;
                try {
                    this.pollResponse(pollTimeoutMs);
                    lastPollTime = Clock.currentTimeMillis() - startMs;
                    timeoutMs = InvocationFuture.decrementTimeout(timeoutMs, lastPollTime);
                    if (this.response == InternalResponse.WAIT_RESPONSE) {
                        RESPONSE.compareAndSet(this, InternalResponse.WAIT_RESPONSE, null);
                        continue;
                    }
                    if (this.response != null) {
                        if (this.response != InternalResponse.INTERRUPTED_RESPONSE && this.interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        Object object = this.response;
                        return object;
                    }
                }
                catch (InterruptedException e) {
                    this.interrupted = true;
                }
                if (this.interrupted || !longPolling) continue;
                Address target = this.invocation.getTarget();
                if (this.invocation.remote && this.invocation.nodeEngine.getThisAddress().equals(target)) continue;
                this.invocation.logger.warning("No response for " + lastPollTime + " ms. " + this.toString());
                boolean executing = this.operationService.getIsStillRunningService().isOperationExecuting(this.invocation);
                if (executing) continue;
                Object operationTimeoutException = this.invocation.newOperationTimeoutException((long)pollCount * pollTimeoutMs);
                if (this.response != null) continue;
                this.set(operationTimeoutException);
            }
            Object object = InternalResponse.TIMEOUT_RESPONSE;
            return object;
        }
        finally {
            WAITER_COUNT.decrementAndGet(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollResponse(long pollTimeoutMs) throws InterruptedException {
        if (pollTimeoutMs <= 0L || this.response != null) {
            return;
        }
        long currentTimeoutMs = pollTimeoutMs;
        long waitStart = Clock.currentTimeMillis();
        InvocationFuture invocationFuture = this;
        synchronized (invocationFuture) {
            while (currentTimeoutMs > 0L && this.response == null) {
                this.wait(currentTimeoutMs);
                currentTimeoutMs = pollTimeoutMs - (Clock.currentTimeMillis() - waitStart);
            }
        }
    }

    long getMaxCallTimeout() {
        long callTimeout = this.invocation.callTimeout;
        long maxCallTimeout = callTimeout + InvocationFuture.getCallTimeoutExtension(callTimeout);
        return maxCallTimeout > 0L ? maxCallTimeout : Long.MAX_VALUE;
    }

    private static long getCallTimeoutExtension(long callTimeout) {
        if (callTimeout <= 0L) {
            return 0L;
        }
        return Math.min(callTimeout, 60000L);
    }

    int getWaitingThreadsCount() {
        return this.waiterCount;
    }

    private static long toTimeoutMs(long time, TimeUnit unit) {
        long timeoutMs = unit.toMillis(time);
        if (timeoutMs < 0L) {
            timeoutMs = 0L;
        }
        return timeoutMs;
    }

    private Object resolveApplicationResponseOrThrowException(Object unresolvedResponse) throws ExecutionException, InterruptedException, TimeoutException {
        Object response = this.resolveApplicationResponse(unresolvedResponse);
        if (response == null || !(response instanceof Throwable)) {
            return response;
        }
        if (response instanceof ExecutionException) {
            throw (ExecutionException)response;
        }
        if (response instanceof TimeoutException) {
            throw (TimeoutException)response;
        }
        if (response instanceof InterruptedException) {
            throw (InterruptedException)response;
        }
        if (response instanceof Error) {
            throw (Error)response;
        }
        throw new ExecutionException((Throwable)response);
    }

    private Object resolveApplicationResponse(Object unresolvedResponse) {
        if (unresolvedResponse == InternalResponse.NULL_RESPONSE) {
            return null;
        }
        if (unresolvedResponse == InternalResponse.TIMEOUT_RESPONSE) {
            return new TimeoutException("Call " + this.invocation + " encountered a timeout");
        }
        if (unresolvedResponse == InternalResponse.INTERRUPTED_RESPONSE) {
            return new InterruptedException("Call " + this.invocation + " was interrupted");
        }
        Object response = unresolvedResponse;
        if (this.invocation.resultDeserialized && response instanceof Data && (response = this.invocation.nodeEngine.toObject(response)) == null) {
            return null;
        }
        if (response instanceof Throwable) {
            Throwable throwable = (Throwable)response;
            if (this.invocation.remote) {
                ExceptionUtil.fixRemoteStackTrace((Throwable)response, Thread.currentThread().getStackTrace());
            }
            return throwable;
        }
        return response;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.responseAvailable(this.response);
    }

    public String toString() {
        return "InvocationFuture{invocation=" + this.invocation.toString() + ", response=" + this.response + ", done=" + this.isDone() + '}';
    }

    private static final class ExecutionCallbackNode<E> {
        private final ExecutionCallback<E> callback;
        private final Executor executor;
        private final ExecutionCallbackNode<E> next;

        private ExecutionCallbackNode(ExecutionCallback<E> callback, Executor executor, ExecutionCallbackNode<E> next) {
            this.callback = callback;
            this.executor = executor;
            this.next = next;
        }
    }
}

