/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EvictionConfigReadOnly;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.internal.eviction.EvictionConfiguration;
import com.hazelcast.internal.eviction.EvictionPolicyType;
import com.hazelcast.internal.eviction.EvictionStrategyType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.io.Serializable;

public class EvictionConfig
implements EvictionConfiguration,
DataSerializable,
Serializable {
    public static final int DEFAULT_MAX_ENTRY_COUNT = 10000;
    public static final EvictionPolicy DEFAULT_EVICTION_POLICY = EvictionPolicy.LRU;
    protected int size = 10000;
    protected MaxSizePolicy maxSizePolicy = MaxSizePolicy.ENTRY_COUNT;
    protected EvictionPolicy evictionPolicy = DEFAULT_EVICTION_POLICY;
    protected EvictionConfig readOnly;

    public EvictionConfig() {
    }

    public EvictionConfig(int size, MaxSizePolicy maxSizePolicy, EvictionPolicy evictionPolicy) {
        if (size > 0) {
            this.size = size;
        }
        if (maxSizePolicy != null) {
            this.maxSizePolicy = maxSizePolicy;
        }
        if (evictionPolicy != null) {
            this.evictionPolicy = evictionPolicy;
        }
    }

    public EvictionConfig(EvictionConfig config) {
        if (config.size > 0) {
            this.size = config.size;
        }
        if (config.maxSizePolicy != null) {
            this.maxSizePolicy = config.maxSizePolicy;
        }
        if (config.evictionPolicy != null) {
            this.evictionPolicy = config.evictionPolicy;
        }
    }

    public EvictionConfig getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new EvictionConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public int getSize() {
        return this.size;
    }

    public EvictionConfig setSize(int size) {
        this.size = Preconditions.checkPositive(size, "Size must be positive number !");
        return this;
    }

    public MaxSizePolicy getMaximumSizePolicy() {
        return this.maxSizePolicy;
    }

    public EvictionConfig setMaximumSizePolicy(MaxSizePolicy maxSizePolicy) {
        this.maxSizePolicy = Preconditions.checkNotNull(maxSizePolicy, "Max-Size policy cannot be null !");
        return this;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public EvictionConfig setEvictionPolicy(EvictionPolicy evictionPolicy) {
        Preconditions.checkNotNull(evictionPolicy, "Eviction policy cannot be null !");
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    @Override
    public EvictionStrategyType getEvictionStrategyType() {
        return EvictionStrategyType.DEFAULT_EVICTION_STRATEGY;
    }

    @Override
    public EvictionPolicyType getEvictionPolicyType() {
        if (this.evictionPolicy == EvictionPolicy.LFU) {
            return EvictionPolicyType.LFU;
        }
        if (this.evictionPolicy == EvictionPolicy.LRU) {
            return EvictionPolicyType.LRU;
        }
        return null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeUTF(this.maxSizePolicy.toString());
        out.writeUTF(this.evictionPolicy.toString());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.size = in.readInt();
        this.maxSizePolicy = MaxSizePolicy.valueOf(in.readUTF());
        this.evictionPolicy = EvictionPolicy.valueOf(in.readUTF());
    }

    public String toString() {
        return "EvictionConfig{size=" + this.size + ", maxSizePolicy=" + (Object)((Object)this.maxSizePolicy) + ", evictionPolicy=" + (Object)((Object)this.evictionPolicy) + ", readOnly=" + this.readOnly + '}';
    }

    public static enum MaxSizePolicy {
        ENTRY_COUNT,
        USED_NATIVE_MEMORY_SIZE,
        USED_NATIVE_MEMORY_PERCENTAGE,
        FREE_NATIVE_MEMORY_SIZE,
        FREE_NATIVE_MEMORY_PERCENTAGE;

    }
}

