/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.testers.AbstractQueueTester;

@GwtCompatible
public class QueueOfferTester<E>
extends AbstractQueueTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testOffer_supportedNotPresent() {
        QueueOfferTester.assertTrue((String)"offer(notPresent) should return true", (boolean)this.getQueue().offer(this.e3()));
        this.expectAdded(this.e3());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.ALLOWS_NULL_VALUES})
    public void testOffer_nullSupported() {
        QueueOfferTester.assertTrue((String)"offer(null) should return true", (boolean)this.getQueue().offer(null));
        this.expectAdded(new Object[]{null});
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD}, absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testOffer_nullUnsupported() {
        try {
            this.getQueue().offer(null);
            QueueOfferTester.fail((String)"offer(null) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullMissingWhenNullUnsupported("Should not contain null after unsupported offer(null)");
    }
}

