/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import javax.lang.model.element.ElementKind;

@BugPattern(name="ParameterPackage", summary="Method parameter has wrong package", explanation="Method does not override method in superclass due to wrong package for parameter. For example, defining a method void foo(alpha.Foo x) when the superclass contains a method void foo(beta.Foo x). The defined method was probably meant to override the superclass method.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class WrongParameterPackage
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private Symbol.MethodSymbol supermethod;

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)tree);
        if (method == null) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol classSym = method.enclClass();
        if (classSym == null) {
            return Description.NO_MATCH;
        }
        Symbol.TypeSymbol superClass = classSym.getSuperclass().tsym;
        if (superClass == null) {
            return Description.NO_MATCH;
        }
        for (Symbol s : superClass.members().getSymbols()) {
            if (!s.name.contentEquals(method.name) || s.getKind() != ElementKind.METHOD) continue;
            Symbol.MethodSymbol supermethod = (Symbol.MethodSymbol)s;
            if (method.overrides(supermethod, superClass, state.getTypes(), true)) {
                return Description.NO_MATCH;
            }
            if (supermethod.params().size() != method.params().size()) continue;
            for (int x = 0; x < method.params().size(); ++x) {
                Type methodParamType = method.params().get((int)x).type;
                Type supermethodParamType = supermethod.params().get((int)x).type;
                if (!methodParamType.tsym.name.contentEquals(supermethodParamType.tsym.name) || state.getTypes().isSameType(methodParamType, supermethodParamType)) continue;
                this.supermethod = supermethod;
                return this.describe(tree, state);
            }
        }
        return Description.NO_MATCH;
    }

    public Description describe(MethodTree tree, VisitorState state) {
        SuggestedFix.Builder builder = null;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)tree);
        if (this.supermethod == null) {
            throw new IllegalStateException("Matching supermethod was not found");
        }
        for (int x = 0; x < method.params().size(); ++x) {
            Type methodParamType = method.params().get((int)x).type;
            Type supermethodParamType = this.supermethod.params().get((int)x).type;
            if (!methodParamType.tsym.name.contentEquals(supermethodParamType.tsym.name) || state.getTypes().isSameType(methodParamType, supermethodParamType)) continue;
            VariableTree param = tree.getParameters().get(x);
            Name replacement = supermethodParamType.tsym.getQualifiedName();
            if (builder == null) {
                builder = SuggestedFix.builder();
            }
            builder.replace((Tree)param, replacement + " " + param.getName());
        }
        return builder != null ? this.describeMatch(tree, (Fix)builder.build()) : this.describeMatch(tree);
    }
}

