/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Bytes;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class PrimitiveByteArraySubject
extends AbstractArraySubject<PrimitiveByteArraySubject, byte[]> {
    private static final char[] hexDigits = "0123456789ABCDEF".toCharArray();

    PrimitiveByteArraySubject(FailureMetadata metadata, @Nullable byte[] o) {
        super(metadata, o);
    }

    @Override
    protected String underlyingType() {
        return "byte";
    }

    @Override
    protected List<Byte> listRepresentation() {
        return Bytes.asList((byte[])((byte[])this.actual()));
    }

    @Override
    public void isEqualTo(Object expected) {
        byte[] actual = (byte[])this.actual();
        if (actual == expected) {
            return;
        }
        try {
            byte[] expectedArray = (byte[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.failComparing("Not true that " + this.getDisplaySubject() + " is equal to <" + Arrays.toString(expectedArray) + ">;", PrimitiveByteArraySubject.base16(expectedArray), PrimitiveByteArraySubject.base16((byte[])this.getSubject()));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    private static String base16(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
        }
        return sb.toString();
    }

    @Override
    public void isNotEqualTo(Object expected) {
        byte[] actual = (byte[])this.actual();
        try {
            byte[] expectedArray = (byte[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Arrays.toString(expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public IterableSubject asList() {
        return this.internalCustomName() != null ? (IterableSubject)this.check().that(this.listRepresentation()).named(this.internalCustomName(), new Object[0]) : this.check().that(this.listRepresentation());
    }
}

