/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bytecode.BytecodeBinder;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.SimpleTopLevelIndex;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.ModuleSymbol;
import com.google.turbine.zip.Zip;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClassPathBinder {
    public static final String TRANSITIVE_PREFIX = "META-INF/TRANSITIVE/";

    public static ClassPath bindClasspath(Collection<Path> paths) throws IOException {
        LinkedHashMap<ClassSymbol, BytecodeBoundClass> transitive = new LinkedHashMap<ClassSymbol, BytecodeBoundClass>();
        final HashMap<ClassSymbol, BytecodeBoundClass> map = new HashMap<ClassSymbol, BytecodeBoundClass>();
        HashMap<ModuleSymbol, ModuleInfo> modules = new HashMap<ModuleSymbol, ModuleInfo>();
        Env<ClassSymbol, BytecodeBoundClass> benv = new Env<ClassSymbol, BytecodeBoundClass>(){

            @Override
            public BytecodeBoundClass get(ClassSymbol sym) {
                return (BytecodeBoundClass)map.get(sym);
            }
        };
        for (Path path : paths) {
            try {
                ClassPathBinder.bindJar(path, map, modules, benv, transitive);
            }
            catch (IOException e) {
                throw new IOException("error reading " + path, e);
            }
        }
        for (Map.Entry entry : transitive.entrySet()) {
            ClassSymbol symbol = (ClassSymbol)entry.getKey();
            if (map.containsKey(symbol)) continue;
            map.put(symbol, (BytecodeBoundClass)entry.getValue());
        }
        final SimpleEnv env = new SimpleEnv(ImmutableMap.copyOf(map));
        final SimpleEnv simpleEnv = new SimpleEnv(ImmutableMap.copyOf(modules));
        final TopLevelIndex index = SimpleTopLevelIndex.of((Iterable<ClassSymbol>)env.asMap().keySet());
        return new ClassPath(){

            @Override
            public Env<ClassSymbol, BytecodeBoundClass> env() {
                return env;
            }

            @Override
            public Env<ModuleSymbol, ModuleInfo> moduleEnv() {
                return simpleEnv;
            }

            @Override
            public TopLevelIndex index() {
                return index;
            }
        };
    }

    private static void bindJar(final Path path, Map<ClassSymbol, BytecodeBoundClass> env, Map<ModuleSymbol, ModuleInfo> modules, final Env<ClassSymbol, BytecodeBoundClass> benv, Map<ClassSymbol, BytecodeBoundClass> transitive) throws IOException {
        for (final Zip.Entry ze : new Zip.ZipIterable(path)) {
            ClassSymbol sym;
            String name = ze.name();
            if (!name.endsWith(".class")) continue;
            if (name.startsWith(TRANSITIVE_PREFIX)) {
                sym = new ClassSymbol(name.substring(TRANSITIVE_PREFIX.length(), name.length() - ".class".length()));
                transitive.computeIfAbsent(sym, (java.util.function.Function<ClassSymbol, BytecodeBoundClass>)new Function<ClassSymbol, BytecodeBoundClass>(){

                    public BytecodeBoundClass apply(ClassSymbol sym) {
                        return new BytecodeBoundClass(sym, (Supplier<byte[]>)ClassPathBinder.toByteArrayOrDie(ze), benv, path.toString());
                    }
                });
                continue;
            }
            if (name.substring(name.lastIndexOf(47) + 1).equals("module-info.class")) {
                ModuleInfo moduleInfo = BytecodeBinder.bindModuleInfo(path.toString(), ClassPathBinder.toByteArrayOrDie(ze));
                modules.put(new ModuleSymbol(moduleInfo.name()), moduleInfo);
                continue;
            }
            sym = new ClassSymbol(name.substring(0, name.length() - ".class".length()));
            if (env.containsKey(sym)) continue;
            env.put(sym, new BytecodeBoundClass(sym, ClassPathBinder.toByteArrayOrDie(ze), benv, path.toString()));
        }
    }

    private static Supplier<byte[]> toByteArrayOrDie(final Zip.Entry ze) {
        return Suppliers.memoize((Supplier)new Supplier<byte[]>(){

            public byte[] get() {
                return ze.data();
            }
        });
    }
}

