/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.nio.tcp.nonblocking.SelectionHandler;
import java.nio.channels.SelectionKey;

public abstract class AbstractClientSelectionHandler
implements SelectionHandler,
Runnable {
    protected final ILogger logger;
    protected final SocketChannelWrapper socketChannel;
    protected final ClientConnection connection;
    protected final ClientConnectionManager connectionManager;
    private final NonBlockingIOThread ioThread;
    private SelectionKey sk;

    public AbstractClientSelectionHandler(ClientConnection connection, NonBlockingIOThread ioThread) {
        this.connection = connection;
        this.ioThread = ioThread;
        this.socketChannel = connection.getSocketChannelWrapper();
        this.connectionManager = connection.getConnectionManager();
        this.logger = Logger.getLogger((String)this.getClass().getName());
    }

    protected void shutdown() {
    }

    public final void onFailure(Throwable e) {
        if (this.sk != null) {
            this.sk.cancel();
        }
        this.connectionManager.destroyConnection(this.connection, e);
    }

    final void registerOp(int operation) {
        try {
            if (!this.connection.isAlive()) {
                return;
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.keyFor(this.ioThread.getSelector());
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.register(this.ioThread.getSelector(), operation, (Object)this);
            } else {
                this.sk.interestOps(this.sk.interestOps() | operation);
                if (this.sk.attachment() != this) {
                    this.sk.attach(this);
                }
            }
        }
        catch (Throwable e) {
            this.onFailure(e);
        }
    }

    public void register() {
        this.ioThread.addTaskAndWakeup((Runnable)this);
    }
}

