/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnalysis;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@BugPattern(name="ImmutableAnnotationChecker", altNames={"Immutable"}, category=BugPattern.Category.JDK, summary="Annotations should always be immutable", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ImmutableAnnotationChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public static final String ANNOTATED_ANNOTATION_MESSAGE = "annotations are immutable by default; annotating them with @com.google.errorprone.annotations.Immutable is unnecessary";
    private static final ImmutableSet<String> PROCESSOR_BLACKLIST = ImmutableSet.of((Object)"com.google.auto.value.processor.AutoAnnotationProcessor");
    private final WellKnownMutability wellKnownMutability;

    @Deprecated
    public ImmutableAnnotationChecker() {
        this(ErrorProneFlags.empty());
    }

    public ImmutableAnnotationChecker(ErrorProneFlags flags) {
        this.wellKnownMutability = WellKnownMutability.fromFlags(flags);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        ThreadSafety.Violation info;
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)tree);
        if (symbol == null || symbol.isAnnotationType() || !WellKnownMutability.isAnnotation(state, symbol.type)) {
            return Description.NO_MATCH;
        }
        if (!Collections.disjoint(ASTHelpers.getGeneratedBy((Symbol.ClassSymbol)symbol, (VisitorState)state), PROCESSOR_BLACKLIST)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol, com.google.errorprone.annotations.Immutable.class, (VisitorState)state)) {
            AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"Immutable");
            if (annotation != null) {
                state.reportMatch(this.buildDescription(annotation).setMessage(ANNOTATED_ANNOTATION_MESSAGE).addFix((Fix)SuggestedFix.delete((Tree)annotation)).build());
            } else {
                state.reportMatch(this.buildDescription(tree).setMessage(ANNOTATED_ANNOTATION_MESSAGE).build());
            }
        }
        if (!(info = new ImmutableAnalysis(this, state, this.wellKnownMutability, (ImmutableSet<String>)ImmutableSet.of((Object)com.google.errorprone.annotations.Immutable.class.getName(), (Object)Immutable.class.getName())).checkForImmutability(Optional.of(tree), (ImmutableSet<String>)ImmutableSet.of(), ASTHelpers.getType((ClassTree)tree), this::describeClass)).isPresent()) {
            return Description.NO_MATCH;
        }
        return this.describeClass(tree, info).build();
    }

    Description.Builder describeClass(Tree tree, ThreadSafety.Violation info) {
        String message = "annotations should be immutable: " + info.message();
        return this.buildDescription(tree).setMessage(message);
    }
}

