/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.bugpatterns.AbstractJUnit4InitMethodNotRun;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodTree;
import java.util.Arrays;
import java.util.List;

@BugPattern(name="JUnit4SetUpNotRun", summary="setUp() method will not be run; please add JUnit's @Before annotation", explanation="JUnit 3 provides the method setUp(), to be overridden by subclasses when the test needs to perform some pre-test initialization. In JUnit 4, this is accomplished by annotating such a method with @Before.\n\n The method that triggered this error matches the definition of setUp() from JUnit3, but was not annotated with @Before and thus won't be run by the JUnit4 runner.\n\n If you intend for this setUp() method not to run by the JUnit4 runner, but perhaps manually be invoked in certain test methods, please rename the method or mark it private. \n\n If the method is part of an abstract test class hierarchy where this class's setUp() is invoked by a superclass method that is annotated with @Before, then please rename the abstract method or add @Before to the superclass's definition of setUp()", category=BugPattern.Category.JUNIT, severity=BugPattern.SeverityLevel.ERROR)
public class JUnit4SetUpNotRun
extends AbstractJUnit4InitMethodNotRun {
    @Override
    protected Matcher<MethodTree> methodMatcher() {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{JUnitMatchers.looksLikeJUnit3SetUp, JUnitMatchers.looksLikeJUnit4Before}), Matchers.not((Matcher)JUnitMatchers.hasJUnit4BeforeAnnotations)});
    }

    @Override
    protected String correctAnnotation() {
        return "org.junit.Before";
    }

    @Override
    protected List<AbstractJUnit4InitMethodNotRun.AnnotationReplacements> annotationReplacements() {
        return Arrays.asList(new AbstractJUnit4InitMethodNotRun.AnnotationReplacements("org.junit.After", "org.junit.Before"), new AbstractJUnit4InitMethodNotRun.AnnotationReplacements("org.junit.AfterClass", "org.junit.BeforeClass"));
    }
}

