/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.ConstructorLeakChecker;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;

@BugPattern(name="ConstructorInvokesOverridable", summary="Constructors should not invoke overridable methods.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class ConstructorInvokesOverridable
extends ConstructorLeakChecker {
    @Override
    protected void traverse(Tree tree, final VisitorState state) {
        ClassTree classTree = (ClassTree)state.findEnclosing(new Class[]{ClassTree.class});
        if (classTree.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return;
        }
        final Symbol.ClassSymbol classSym = ASTHelpers.getSymbol((ClassTree)classTree);
        tree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void data) {
                Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodInvocationTree)node);
                if (!(method == null || method.isConstructor() || method.isStatic() || method.isPrivate() || method.getModifiers().contains((Object)Modifier.FINAL) || !method.isMemberOf(classSym, state.getTypes()))) {
                    state.reportMatch(ConstructorInvokesOverridable.this.describeMatch(node));
                }
                return (Void)super.visitMethodInvocation(node, data);
            }
        }, null);
    }
}

