/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.common.primitives.Ints;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.math.BigDecimal;
import java.math.BigInteger;

@BugPattern(name="BigDecimalLiteralDouble", summary="BigDecimal(double) and BigDecimal.valueOf(double) may lose precision, prefer BigDecimal(String) or BigDecimal(long)", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class BigDecimalLiteralDouble
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final String BIG_DECIMAL = BigDecimal.class.getName();
    private static final Matcher<ExpressionTree> valueOfMethod = MethodMatchers.staticMethod().onClass(BIG_DECIMAL).named("valueOf").withParameters(new String[]{"double"});
    private static final Matcher<ExpressionTree> constructor = Matchers.constructor().forClass(BIG_DECIMAL).withParameters(new String[]{"double"});
    private static final Matcher<ExpressionTree> literalArgument = new Matcher<ExpressionTree>(){

        public boolean matches(ExpressionTree tree, VisitorState state) {
            if (tree.getKind() == Tree.Kind.UNARY_PLUS || tree.getKind() == Tree.Kind.UNARY_MINUS) {
                tree = ((UnaryTree)tree).getExpression();
            }
            return tree.getKind() == Tree.Kind.DOUBLE_LITERAL;
        }
    };

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!valueOfMethod.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = tree.getArguments().get(0);
        if (!literalArgument.matches((Tree)arg, state)) {
            return Description.NO_MATCH;
        }
        return this.createDescription(tree, arg, state, false);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!constructor.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = tree.getArguments().get(0);
        if (!literalArgument.matches((Tree)arg, state)) {
            return Description.NO_MATCH;
        }
        return this.createDescription(tree, arg, state, true);
    }

    public Description createDescription(ExpressionTree tree, ExpressionTree arg, VisitorState state, boolean suggestIntegral) {
        String literal = state.getSourceForNode((Tree)arg);
        if (literal == null) {
            return this.describeMatch(tree);
        }
        literal = literal.replaceAll("[_dD]", "");
        BigDecimal intendedValue = new BigDecimal(literal);
        Optional<BigInteger> integralValue = BigDecimalLiteralDouble.asBigInteger(intendedValue);
        Description.Builder description = this.buildDescription(tree);
        if (suggestIntegral && integralValue.isPresent() && this.isWithinLongRange((BigInteger)integralValue.get())) {
            String suggestedString;
            long longValue = ((BigInteger)integralValue.get()).longValue();
            switch (Ints.saturatedCast((long)longValue)) {
                case 0: {
                    suggestedString = "BigDecimal.ZERO";
                    break;
                }
                case 1: {
                    suggestedString = "BigDecimal.ONE";
                    break;
                }
                case 10: {
                    suggestedString = "BigDecimal.TEN";
                    break;
                }
                default: {
                    suggestedString = "new BigDecimal(" + longValue + "L)";
                }
            }
            description.addFix((Fix)SuggestedFix.builder().addImport("java.math.BigDecimal").replace((Tree)tree, suggestedString).build());
        }
        description.addFix((Fix)SuggestedFix.builder().addImport("java.math.BigDecimal").replace((Tree)tree, "new BigDecimal(\"" + literal + "\")").build());
        return description.build();
    }

    public static Optional<BigInteger> asBigInteger(BigDecimal v) {
        try {
            return Optional.of((Object)v.toBigIntegerExact());
        }
        catch (ArithmeticException e) {
            return Optional.absent();
        }
    }

    private boolean isWithinLongRange(BigInteger v) {
        return LONG_MIN.compareTo(v) <= 0 && v.compareTo(LONG_MAX) <= 0;
    }
}

