/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.ParseExpr;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjectMap;

public final class VarRef
extends ParseExpr {
    public final Var var;

    public VarRef(InputInfo info, Var var) {
        super(info, SeqType.ITEM_ZM);
        this.var = var;
    }

    @Override
    public Expr compile(CompileContext cc) {
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        return this.var.seqType().zero() ? Empty.VALUE : this.assignType();
    }

    @Override
    public Value value(QueryContext qc) {
        return qc.get(this.var);
    }

    @Override
    public boolean ddo() {
        return this.var.ddo();
    }

    @Override
    public boolean inlineable(InlineContext v) {
        return true;
    }

    @Override
    public VarUsage count(Var v) {
        return this.var == v ? VarUsage.ONCE : VarUsage.NEVER;
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        return this.var == ic.var ? ic.copy() : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        Var nw = vm.get(this.var.id);
        return new VarRef(this.info, nw != null ? nw : this.var).assignType();
    }

    private VarRef assignType() {
        this.exprType.assign(this.var.seqType(), this.var.size()).data(this.var.data());
        return this;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.used(this);
    }

    @Override
    public void checkUp() {
    }

    @Override
    public boolean has(Flag ... flags) {
        return false;
    }

    @Override
    public int exprSize() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof VarRef)) return false;
        VarRef vr = (VarRef)obj;
        if (this.var.slot != vr.var.slot) return false;
        return true;
    }

    @Override
    public String description() {
        return "variable";
    }

    @Override
    public void toXml(QueryPlan plan) {
        FBuilder elem = plan.create(this, new Object[0]);
        plan.addAttribute(elem, "name", this.var.toErrorString());
        plan.addAttribute(elem, Token.ID, this.var.id);
        plan.add(elem, new ExprInfo[0]);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.var.id());
    }

    @Override
    public String toErrorString() {
        return this.var.toErrorString();
    }
}

