/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.csv.CsvSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;
import org.basex.util.list.TokenList;

public final class CsvW3Serializer
extends CsvSerializer {
    public CsvW3Serializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
    }

    @Override
    public void serialize(Item item) throws IOException {
        if (this.sep && this.level == 0) {
            this.out.print(32);
        }
        if (!(item instanceof XQMap)) {
            throw QueryError.CSV_SERIALIZE_X_X.getIO("Top level must be a map, found " + String.valueOf(item.type), item);
        }
        XQMap map = (XQMap)item;
        TokenList tl = new TokenList();
        try {
            if (this.header) {
                if (!map.contains(CsvConverter.COLUMNS)) {
                    throw QueryError.CSV_SERIALIZE_X.getIO("Map has no 'columns' key");
                }
                this.row(map.get(CsvConverter.COLUMNS), tl);
            }
            if (!map.contains(CsvConverter.ROWS)) {
                throw QueryError.CSV_SERIALIZE_X.getIO("Map has no 'rows' key");
            }
            for (Item record : map.get(CsvConverter.ROWS)) {
                this.row(((XQArray)record).iterable(), tl);
            }
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
        this.sep = true;
    }

    private void row(Iterable<? extends Value> line, TokenList tl) throws QueryException, IOException {
        for (Value value : line) {
            if (value.size() != 1L) {
                throw QueryError.CSV_SERIALIZE_X_X.getIO("Item expected, found " + String.valueOf(value.seqType()), value);
            }
            tl.add(((Item)value).string(null));
        }
        this.record(tl);
    }
}

