/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.datanucleus.EmulatedXAResource;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;

public class KeyRegistry {
    private final Map<Object, Key> parentKeyMap = new IdentityHashMap<Object, Key>();
    private final Set<Object> unownedObjects = new HashSet<Object>();

    public static KeyRegistry getKeyRegistry(ExecutionContext ec) {
        StoreManager storeManager = ec.getStoreManager();
        ManagedConnection mconn = storeManager.getConnection(ec);
        return ((EmulatedXAResource)mconn.getXAResource()).getKeyRegistry();
    }

    public void registerParentKeyForOwnedObject(Object obj, Key parentKey) {
        this.parentKeyMap.put(obj, parentKey);
    }

    public Key getParentKeyForOwnedObject(Object obj) {
        return this.parentKeyMap.get(obj);
    }

    public void clearParentKeys() {
        this.parentKeyMap.clear();
    }

    public void registerUnownedObject(Object obj) {
        this.unownedObjects.add(obj);
    }

    public boolean isUnowned(Object obj) {
        return this.unownedObjects.contains(obj);
    }

    public void clearUnownedObjects() {
        this.unownedObjects.clear();
    }
}

