/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.BaseDatastoreService;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.labs.datastore.overlay.DelegatedBaseDatastoreService;
import com.google.appengine.api.labs.datastore.overlay.FakeFutureTask;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

final class LazyAsyncDatastoreServiceAdapter
extends DelegatedBaseDatastoreService
implements AsyncDatastoreService {
    private final DatastoreService datastore;

    public LazyAsyncDatastoreServiceAdapter(DatastoreService datastore) {
        super((BaseDatastoreService)datastore);
        this.datastore = datastore;
    }

    public Future<Entity> get(final Key key) {
        return new FakeFutureTask<Entity>(){

            @Override
            protected Entity call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.get(key);
            }
        };
    }

    public Future<Entity> get(final Transaction txn, final Key key) {
        return new FakeFutureTask<Entity>(){

            @Override
            protected Entity call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.get(txn, key);
            }
        };
    }

    public Future<Map<Key, Entity>> get(final Iterable<Key> keys) {
        return new FakeFutureTask<Map<Key, Entity>>(){

            @Override
            protected Map<Key, Entity> call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.get(keys);
            }
        };
    }

    public Future<Map<Key, Entity>> get(final Transaction txn, final Iterable<Key> keys) {
        return new FakeFutureTask<Map<Key, Entity>>(){

            @Override
            protected Map<Key, Entity> call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.get(txn, keys);
            }
        };
    }

    public Future<Key> put(final Entity entity) {
        return new FakeFutureTask<Key>(){

            @Override
            protected Key call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.put(entity);
            }
        };
    }

    public Future<Key> put(final Transaction txn, final Entity entity) {
        return new FakeFutureTask<Key>(){

            @Override
            protected Key call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.put(txn, entity);
            }
        };
    }

    public Future<List<Key>> put(final Iterable<Entity> entities) {
        return new FakeFutureTask<List<Key>>(){

            @Override
            protected List<Key> call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.put(entities);
            }
        };
    }

    public Future<List<Key>> put(final Transaction txn, final Iterable<Entity> entities) {
        return new FakeFutureTask<List<Key>>(){

            @Override
            protected List<Key> call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.put(txn, entities);
            }
        };
    }

    public Future<Void> delete(final Key ... keys) {
        return new FakeFutureTask<Void>(){

            @Override
            protected Void call() throws Exception {
                LazyAsyncDatastoreServiceAdapter.this.datastore.delete(keys);
                return null;
            }
        };
    }

    public Future<Void> delete(final Transaction txn, final Key ... keys) {
        return new FakeFutureTask<Void>(){

            @Override
            protected Void call() throws Exception {
                LazyAsyncDatastoreServiceAdapter.this.datastore.delete(txn, keys);
                return null;
            }
        };
    }

    public Future<Void> delete(final Iterable<Key> keys) {
        return new FakeFutureTask<Void>(){

            @Override
            protected Void call() throws Exception {
                LazyAsyncDatastoreServiceAdapter.this.datastore.delete(keys);
                return null;
            }
        };
    }

    public Future<Void> delete(final Transaction txn, final Iterable<Key> keys) {
        return new FakeFutureTask<Void>(){

            @Override
            protected Void call() throws Exception {
                LazyAsyncDatastoreServiceAdapter.this.datastore.delete(txn, keys);
                return null;
            }
        };
    }

    public Future<Transaction> beginTransaction() {
        return new FakeFutureTask<Transaction>(){

            @Override
            protected Transaction call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.beginTransaction();
            }
        };
    }

    public Future<Transaction> beginTransaction(final TransactionOptions options) {
        return new FakeFutureTask<Transaction>(){

            @Override
            protected Transaction call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.beginTransaction(options);
            }
        };
    }

    public Future<KeyRange> allocateIds(final String kind, final long num) {
        return new FakeFutureTask<KeyRange>(){

            @Override
            protected KeyRange call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.allocateIds(kind, num);
            }
        };
    }

    public Future<KeyRange> allocateIds(final Key parent, final String kind, final long num) {
        return new FakeFutureTask<KeyRange>(){

            @Override
            protected KeyRange call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.allocateIds(parent, kind, num);
            }
        };
    }

    public Future<DatastoreAttributes> getDatastoreAttributes() {
        return new FakeFutureTask<DatastoreAttributes>(){

            @Override
            protected DatastoreAttributes call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.getDatastoreAttributes();
            }
        };
    }

    public Future<Map<Index, Index.IndexState>> getIndexes() {
        return new FakeFutureTask<Map<Index, Index.IndexState>>(){

            @Override
            protected Map<Index, Index.IndexState> call() throws Exception {
                return LazyAsyncDatastoreServiceAdapter.this.datastore.getIndexes();
            }
        };
    }
}

