/**********************************************************************
Copyright (c) 2002 Kelly Grizzle (TJDO) and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 

Contributors:
2003 Andy Jefferson - coding standards
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

/**
 * Representation of a Byte expression in a Query.
 *
 * @version $Revision: 1.9 $
 **/
public class ByteExpression extends NumericExpression
{

    /**
     * Constructor
     * @param qs the QueryExpression
     */
    protected ByteExpression(QueryExpression qs)
    {
        super(qs);
    }
    
    /**
     * 
     * @param qs the QueryExpression
     * @param mapping the mapping associated to this expression
     * @param te the TableExpression where this expression refers to
     */
    public ByteExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te)
    {
        super(qs, mapping, te);
    }
    
    /**
     * Perform a function <code>op</code> on <code>operand</code> 
     * @param op operator
     * @param operand operand
     */    
    public ByteExpression(MonadicOperator op, ScalarExpression operand)
    {
        super(op, operand);
    }

    /**
     * Performs a function on two arguments.
     * op(operand1,operand2)
     * operand1 op operand2 
     * @param operand1 the first expression
     * @param op the operator between operands
     * @param operand2 the second expression
     */    
    public ByteExpression(ScalarExpression operand1, DyadicOperator op, ScalarExpression operand2)
    {
        super(operand1, op, operand2);
    }
    
    public BooleanExpression eq(ScalarExpression expr)
    {
        if (expr instanceof NullLiteral)
        {
            return expr.eq(this);
        }
        else
        {
            return super.eq(expr);
        }
    }   
    public BooleanExpression noteq(ScalarExpression expr)
    {
        if (expr instanceof NullLiteral)
        {
            return expr.noteq(this);
        }
        else
        {
            return super.noteq(expr);
        }
    } 
    public BooleanExpression lt(ScalarExpression expr)
    {
        if (expr instanceof NullLiteral)
        {
            return expr.lt(this);
        }
        else
        {
            return super.lt(expr);
        }
    } 
    public BooleanExpression lteq(ScalarExpression expr)
    {
        if (expr instanceof NullLiteral)
        {
            return expr.lteq(this);
        }
        else
        {
            return super.lteq(expr);
        }
    }   
    public BooleanExpression gt(ScalarExpression expr)
    {
        if (expr instanceof NullLiteral)
        {
            return expr.gt(this);
        }
        else
        {
            return super.gt(expr);
        }
    } 
    public BooleanExpression gteq(ScalarExpression expr)
    {
        if (expr instanceof NullLiteral)
        {
            return expr.gteq(this);
        }
        else
        {
            return super.gteq(expr);
        }
    }
}