/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class ListResponse<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1189234703739911898L;
    private final List<T> results;

    ListResponse(List<T> results) {
        this.results = Collections.unmodifiableList(Preconditions.checkNotNull(results, "results cannot be null"));
    }

    @Override
    public Iterator<T> iterator() {
        return this.results.iterator();
    }

    public List<T> getResults() {
        return this.results;
    }

    public String toString() {
        return String.format("ListResponse(results=%s)", Util.iterableToString(this.results, 0));
    }
}

