/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Parser {
    public static Action lookupAction(List<Action> actions, String[] args, int index) {
        for (Action action : actions) {
            if (!Parser.matchesAction(action, args, index)) continue;
            return action;
        }
        return null;
    }

    private static boolean matchesAction(Action action, String[] args, int index) {
        if (args.length - index < action.getNames().length) {
            return false;
        }
        for (String name : action.getNames()) {
            if (name.equals(args[index++])) continue;
            return false;
        }
        return true;
    }

    public ParseResult parseArgs(Action action, List<Option> options, String[] cmdLineArgs) {
        ArrayList<Option> parsedOptions = new ArrayList<Option>();
        int currentArg = this.parseOptions(options, parsedOptions, cmdLineArgs);
        List<String> actionArgs = Arrays.asList(cmdLineArgs).subList(currentArg, cmdLineArgs.length);
        action.setArgs(actionArgs);
        return new ParseResult(parsedOptions, action);
    }

    public ParseResult parseArgs(List<Action> actions, List<Option> options, String[] cmdLineArgs) {
        ArrayList<Option> parsedOptions = new ArrayList<Option>();
        int currentArg = this.parseOptions(options, parsedOptions, cmdLineArgs);
        if (currentArg >= cmdLineArgs.length) {
            throw new IllegalArgumentException("Expected an action: " + Parser.buildActionString(actions));
        }
        String actionString = cmdLineArgs[currentArg];
        if (actionString.startsWith("-") || actionString.startsWith("--")) {
            throw new IllegalArgumentException("Unknown option: " + actionString);
        }
        Action foundAction = Parser.lookupAction(actions, cmdLineArgs, currentArg);
        if (foundAction == null) {
            throw new IllegalArgumentException("Expected an action: " + Parser.buildActionString(actions));
        }
        List<String> actionArgs = Arrays.asList(cmdLineArgs).subList(currentArg += foundAction.getNames().length, cmdLineArgs.length);
        foundAction.setArgs(actionArgs);
        return new ParseResult(parsedOptions, foundAction);
    }

    private int parseOptions(List<Option> availableOptions, List<Option> parsedOptions, String[] cmdLineArgs) {
        Option option;
        int currentArg = -1;
        while (++currentArg < cmdLineArgs.length && (option = Parser.parseArg(availableOptions, cmdLineArgs, currentArg)) != null) {
            parsedOptions.add(option);
            if (option.getArgStyle() != Option.Style.Short) continue;
            ++currentArg;
        }
        return currentArg;
    }

    private static String buildActionString(List<Action> actions) {
        StringBuffer msg = new StringBuffer("[");
        for (int i = 0; i < actions.size(); ++i) {
            Action action = actions.get(i);
            msg.append(action.getNameString());
            if (i != actions.size() - 1) {
                msg.append(", ");
                continue;
            }
            msg.append("]");
        }
        return msg.toString();
    }

    private static Option parseArg(List<Option> optionParsers, String[] cmdLineArgs, int currentArg) {
        for (Option option : optionParsers) {
            if (!option.parse(cmdLineArgs, currentArg)) continue;
            return option;
        }
        return null;
    }

    public static class ParseResult {
        private final List<Option> parsedOptions;
        private final Action action;

        ParseResult(List<Option> parsedOptions, Action action) {
            this.parsedOptions = parsedOptions;
            this.action = action;
        }

        public List<Option> getParsedOptions() {
            return this.parsedOptions;
        }

        public Action getAction() {
            return this.action;
        }

        public void applyArgs() {
            for (Option option : this.parsedOptions) {
                option.apply();
            }
            this.action.apply();
        }
    }
}

