/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgView {
    private List<String> columnNames;
    private final String name;
    private String query;
    private final List<DefaultValue> defaultValues = new ArrayList<DefaultValue>(0);
    private final List<ColumnComment> columnComments = new ArrayList<ColumnComment>(0);
    private String comment;

    public PgView(String name) {
        this.name = name;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCreationSQL() {
        StringBuilder sbSQL = new StringBuilder(this.query.length() * 2);
        sbSQL.append("CREATE VIEW ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.name));
        if (this.columnNames != null && !this.columnNames.isEmpty()) {
            sbSQL.append(" (");
            for (int i = 0; i < this.columnNames.size(); ++i) {
                if (i > 0) {
                    sbSQL.append(", ");
                }
                sbSQL.append(PgDiffUtils.getQuotedName(this.columnNames.get(i)));
            }
            sbSQL.append(')');
        }
        sbSQL.append(" AS\n\t");
        sbSQL.append(this.query);
        sbSQL.append(';');
        for (DefaultValue defaultValue : this.defaultValues) {
            sbSQL.append("\n\nALTER VIEW ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append(" ALTER COLUMN ");
            sbSQL.append(PgDiffUtils.getQuotedName(defaultValue.getColumnName()));
            sbSQL.append(" SET DEFAULT ");
            sbSQL.append(defaultValue.getDefaultValue());
            sbSQL.append(';');
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            sbSQL.append("\n\nCOMMENT ON VIEW ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append(" IS ");
            sbSQL.append(this.comment);
            sbSQL.append(';');
        }
        for (ColumnComment columnComment : this.columnComments) {
            if (columnComment.getComment() == null || columnComment.getComment().isEmpty()) continue;
            sbSQL.append("\n\nCOMMENT ON COLUMN ");
            sbSQL.append(PgDiffUtils.getQuotedName(columnComment.getColumnName()));
            sbSQL.append(" IS ");
            sbSQL.append(columnComment.getComment());
            sbSQL.append(';');
        }
        return sbSQL.toString();
    }

    public String getDropSQL() {
        return "DROP VIEW " + PgDiffUtils.getQuotedName(this.getName()) + ";";
    }

    public String getName() {
        return this.name;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void addColumnDefaultValue(String columnName, String defaultValue) {
        this.removeColumnDefaultValue(columnName);
        this.defaultValues.add(new DefaultValue(columnName, defaultValue));
    }

    public void removeColumnDefaultValue(String columnName) {
        for (DefaultValue item : this.defaultValues) {
            if (!item.getColumnName().equals(columnName)) continue;
            this.defaultValues.remove(item);
            return;
        }
    }

    public List<DefaultValue> getDefaultValues() {
        return Collections.unmodifiableList(this.defaultValues);
    }

    public void addColumnComment(String columnName, String comment) {
        this.removeColumnDefaultValue(columnName);
        this.columnComments.add(new ColumnComment(columnName, comment));
    }

    public void removeColumnComment(String columnName) {
        for (ColumnComment item : this.columnComments) {
            if (!item.getColumnName().equals(columnName)) continue;
            this.columnComments.remove(item);
            return;
        }
    }

    public List<ColumnComment> getColumnComments() {
        return Collections.unmodifiableList(this.columnComments);
    }

    public class ColumnComment {
        private final String columnName;
        private final String comment;

        ColumnComment(String columnName, String comment) {
            this.columnName = columnName;
            this.comment = comment;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getComment() {
            return this.comment;
        }
    }

    public class DefaultValue {
        private final String columnName;
        private final String defaultValue;

        DefaultValue(String columnName, String defaultValue) {
            this.columnName = columnName;
            this.defaultValue = defaultValue;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

