/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgTrigger {
    private String function;
    private String name;
    private String tableName;
    private boolean before = true;
    private boolean forEachRow;
    private boolean onDelete;
    private boolean onInsert;
    private boolean onUpdate;
    private boolean onTruncate;
    private final List<String> updateColumns = new ArrayList<String>();
    private String when;
    private String comment;

    public void setBefore(boolean before) {
        this.before = before;
    }

    public boolean isBefore() {
        return this.before;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCreationSQL() {
        StringBuilder sbSQL = new StringBuilder(100);
        sbSQL.append("CREATE TRIGGER ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.getName()));
        sbSQL.append("\n\t");
        sbSQL.append(this.isBefore() ? "BEFORE" : "AFTER");
        boolean firstEvent = true;
        if (this.isOnInsert()) {
            sbSQL.append(" INSERT");
            firstEvent = false;
        }
        if (this.isOnUpdate()) {
            if (firstEvent) {
                firstEvent = false;
            } else {
                sbSQL.append(" OR");
            }
            sbSQL.append(" UPDATE");
            if (!this.updateColumns.isEmpty()) {
                sbSQL.append(" OF");
                boolean first = true;
                for (String columnName : this.updateColumns) {
                    if (first) {
                        first = false;
                    } else {
                        sbSQL.append(',');
                    }
                    sbSQL.append(' ');
                    sbSQL.append(columnName);
                }
            }
        }
        if (this.isOnDelete()) {
            if (!firstEvent) {
                sbSQL.append(" OR");
            }
            sbSQL.append(" DELETE");
        }
        if (this.isOnTruncate()) {
            if (!firstEvent) {
                sbSQL.append(" OR");
            }
            sbSQL.append(" TRUNCATE");
        }
        sbSQL.append(" ON ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.getTableName()));
        sbSQL.append("\n\tFOR EACH ");
        sbSQL.append(this.isForEachRow() ? "ROW" : "STATEMENT");
        if (this.when != null && !this.when.isEmpty()) {
            sbSQL.append("\n\tWHEN (");
            sbSQL.append(this.when);
            sbSQL.append(')');
        }
        sbSQL.append("\n\tEXECUTE PROCEDURE ");
        sbSQL.append(this.getFunction());
        sbSQL.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            sbSQL.append("\n\nCOMMENT ON TRIGGER ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append(" ON ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.tableName));
            sbSQL.append(" IS ");
            sbSQL.append(this.comment);
            sbSQL.append(';');
        }
        return sbSQL.toString();
    }

    public String getDropSQL() {
        return "DROP TRIGGER " + PgDiffUtils.getQuotedName(this.getName()) + " ON " + PgDiffUtils.getQuotedName(this.getTableName()) + ";";
    }

    public void setForEachRow(boolean forEachRow) {
        this.forEachRow = forEachRow;
    }

    public boolean isForEachRow() {
        return this.forEachRow;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getFunction() {
        return this.function;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOnDelete(boolean onDelete) {
        this.onDelete = onDelete;
    }

    public boolean isOnDelete() {
        return this.onDelete;
    }

    public void setOnInsert(boolean onInsert) {
        this.onInsert = onInsert;
    }

    public boolean isOnInsert() {
        return this.onInsert;
    }

    public void setOnUpdate(boolean onUpdate) {
        this.onUpdate = onUpdate;
    }

    public boolean isOnUpdate() {
        return this.onUpdate;
    }

    public boolean isOnTruncate() {
        return this.onTruncate;
    }

    public void setOnTruncate(boolean onTruncate) {
        this.onTruncate = onTruncate;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getUpdateColumns() {
        return Collections.unmodifiableList(this.updateColumns);
    }

    public void addUpdateColumn(String columnName) {
        this.updateColumns.add(columnName);
    }

    public String getWhen() {
        return this.when;
    }

    public void setWhen(String when) {
        this.when = when;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (this == object) {
            equals = true;
        } else if (object instanceof PgTrigger) {
            PgTrigger trigger = (PgTrigger)object;
            boolean bl = equals = this.before == trigger.isBefore() && this.forEachRow == trigger.isForEachRow() && this.function.equals(trigger.getFunction()) && this.name.equals(trigger.getName()) && this.onDelete == trigger.isOnDelete() && this.onInsert == trigger.isOnInsert() && this.onUpdate == trigger.isOnUpdate() && this.onTruncate == trigger.isOnTruncate() && this.tableName.equals(trigger.getTableName());
            if (equals) {
                ArrayList<String> sorted1 = new ArrayList<String>(this.updateColumns);
                ArrayList<String> sorted2 = new ArrayList<String>(trigger.getUpdateColumns());
                Collections.sort(sorted1);
                Collections.sort(sorted2);
                equals = sorted1.equals(sorted2);
            }
        }
        return equals;
    }

    public int hashCode() {
        return (this.getClass().getName() + "|" + this.before + "|" + this.forEachRow + "|" + this.function + "|" + this.name + "|" + this.onDelete + "|" + this.onInsert + "|" + this.onUpdate + "|" + this.onTruncate + "|" + this.tableName).hashCode();
    }
}

