/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgIndex;
import cz.startnet.utils.pgdiff.schema.PgTrigger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgTable {
    private final List<PgColumn> columns = new ArrayList<PgColumn>();
    private final List<PgConstraint> constraints = new ArrayList<PgConstraint>();
    private final List<PgIndex> indexes = new ArrayList<PgIndex>();
    private final List<PgTrigger> triggers = new ArrayList<PgTrigger>();
    private String clusterIndexName;
    private final List<String> inherits = new ArrayList<String>();
    private String name;
    private String with;
    private String tablespace;
    private String comment;

    public PgTable(String name) {
        this.name = name;
    }

    public void setClusterIndexName(String name) {
        this.clusterIndexName = name;
    }

    public String getClusterIndexName() {
        return this.clusterIndexName;
    }

    public PgColumn getColumn(String name) {
        for (PgColumn column : this.columns) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public List<PgColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public PgConstraint getConstraint(String name) {
        for (PgConstraint constraint : this.constraints) {
            if (!constraint.getName().equals(name)) continue;
            return constraint;
        }
        return null;
    }

    public List<PgConstraint> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public String getCreationSQL() {
        StringBuilder sbSQL = new StringBuilder(1000);
        sbSQL.append("CREATE TABLE ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.name));
        sbSQL.append(" (\n");
        boolean first = true;
        if (this.columns.isEmpty()) {
            sbSQL.append(')');
        } else {
            for (PgColumn column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    sbSQL.append(",\n");
                }
                sbSQL.append("\t");
                sbSQL.append(column.getFullDefinition(false));
            }
            sbSQL.append("\n)");
        }
        if (this.inherits != null && !this.inherits.isEmpty()) {
            sbSQL.append("\nINHERITS (");
            first = true;
            for (String tableName : this.inherits) {
                if (first) {
                    first = false;
                } else {
                    sbSQL.append(", ");
                }
                sbSQL.append(tableName);
            }
            sbSQL.append(")");
        }
        if (this.with != null && !this.with.isEmpty()) {
            sbSQL.append("\n");
            if ("OIDS=false".equalsIgnoreCase(this.with)) {
                sbSQL.append("WITHOUT OIDS");
            } else {
                sbSQL.append("WITH ");
                if ("OIDS".equalsIgnoreCase(this.with) || "OIDS=true".equalsIgnoreCase(this.with)) {
                    sbSQL.append("OIDS");
                } else {
                    sbSQL.append(this.with);
                }
            }
        }
        if (this.tablespace != null && !this.tablespace.isEmpty()) {
            sbSQL.append("\nTABLESPACE ");
            sbSQL.append(this.tablespace);
        }
        sbSQL.append(';');
        for (PgColumn column : this.getColumnsWithStatistics()) {
            sbSQL.append("\nALTER TABLE ONLY ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append(" ALTER COLUMN ");
            sbSQL.append(PgDiffUtils.getQuotedName(column.getName()));
            sbSQL.append(" SET STATISTICS ");
            sbSQL.append(column.getStatistics());
            sbSQL.append(';');
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            sbSQL.append("\n\nCOMMENT ON TABLE ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append(" IS ");
            sbSQL.append(this.comment);
            sbSQL.append(';');
        }
        for (PgColumn column : this.columns) {
            if (column.getComment() == null || column.getComment().isEmpty()) continue;
            sbSQL.append("\n\nCOMMENT ON COLUMN ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append('.');
            sbSQL.append(PgDiffUtils.getQuotedName(column.getName()));
            sbSQL.append(" IS ");
            sbSQL.append(column.getComment());
            sbSQL.append(';');
        }
        return sbSQL.toString();
    }

    public String getDropSQL() {
        return "DROP TABLE " + PgDiffUtils.getQuotedName(this.getName()) + ";";
    }

    public PgIndex getIndex(String name) {
        for (PgIndex index : this.indexes) {
            if (!index.getName().equals(name)) continue;
            return index;
        }
        return null;
    }

    public PgTrigger getTrigger(String name) {
        for (PgTrigger trigger : this.triggers) {
            if (!trigger.getName().equals(name)) continue;
            return trigger;
        }
        return null;
    }

    public List<PgIndex> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    public void addInherits(String tableName) {
        this.inherits.add(tableName);
    }

    public List<String> getInherits() {
        return Collections.unmodifiableList(this.inherits);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<PgTrigger> getTriggers() {
        return Collections.unmodifiableList(this.triggers);
    }

    public void setWith(String with) {
        this.with = with;
    }

    public String getWith() {
        return this.with;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    public void addColumn(PgColumn column) {
        this.columns.add(column);
    }

    public void addConstraint(PgConstraint constraint) {
        this.constraints.add(constraint);
    }

    public void addIndex(PgIndex index) {
        this.indexes.add(index);
    }

    public void addTrigger(PgTrigger trigger) {
        this.triggers.add(trigger);
    }

    public boolean containsColumn(String name) {
        for (PgColumn column : this.columns) {
            if (!column.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsConstraint(String name) {
        for (PgConstraint constraint : this.constraints) {
            if (!constraint.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsIndex(String name) {
        for (PgIndex index : this.indexes) {
            if (!index.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private List<PgColumn> getColumnsWithStatistics() {
        ArrayList<PgColumn> list = new ArrayList<PgColumn>();
        for (PgColumn column : this.columns) {
            if (column.getStatistics() == null) continue;
            list.add(column);
        }
        return list;
    }
}

