/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgDatabase {
    private final List<PgSchema> schemas = new ArrayList<PgSchema>(1);
    private final List<String> ignoredStatements = new ArrayList<String>();
    private PgSchema defaultSchema;
    private String comment;

    public PgDatabase() {
        this.schemas.add(new PgSchema("public"));
        this.defaultSchema = this.schemas.get(0);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDefaultSchema(String name) {
        this.defaultSchema = this.getSchema(name);
    }

    public PgSchema getDefaultSchema() {
        return this.defaultSchema;
    }

    public List<String> getIgnoredStatements() {
        return Collections.unmodifiableList(this.ignoredStatements);
    }

    public void addIgnoredStatement(String ignoredStatement) {
        this.ignoredStatements.add(ignoredStatement);
    }

    public PgSchema getSchema(String name) {
        if (name == null) {
            return this.getDefaultSchema();
        }
        for (PgSchema schema : this.schemas) {
            if (!schema.getName().equals(name)) continue;
            return schema;
        }
        return null;
    }

    public List<PgSchema> getSchemas() {
        return Collections.unmodifiableList(this.schemas);
    }

    public void addSchema(PgSchema schema) {
        this.schemas.add(schema);
    }
}

