/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.LongDateRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    LongDateRec dateRec;
    LongDateRec dateAndTime = new LongDateRec();
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    Color fg;
    Color bg;
    Calendar calendar;
    DateFormatSymbols formatSymbols;
    Button monthDown;
    Button monthUp;
    Button yearDown;
    Button yearUp;
    static final int MARGIN_WIDTH = 2;
    static final int MARGIN_HEIGHT = 1;

    public DateTime(Composite composite, int n) {
        super(composite, DateTime.checkStyle(n) | ((n & 0x400) != 0 ? 0x100000 : 0));
        if ((this.style & 0x400) != 0) {
            this.calendar = Calendar.getInstance();
            this.formatSymbols = new DateFormatSymbols();
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 9: {
                            DateTime.this.handlePaint(event);
                            break;
                        }
                        case 11: {
                            DateTime.this.handleResize(event);
                            break;
                        }
                        case 3: {
                            DateTime.this.handleMouseDown(event);
                            break;
                        }
                        case 1: {
                            DateTime.this.handleKeyDown(event);
                            break;
                        }
                        case 31: {
                            DateTime.this.handleTraverse(event);
                        }
                    }
                }
            };
            this.addListener(9, listener);
            this.addListener(11, listener);
            this.addListener(3, listener);
            this.addListener(1, listener);
            this.addListener(31, listener);
            this.yearDown = new Button(this, 16388);
            this.monthDown = new Button(this, 16388);
            this.monthUp = new Button(this, 131076);
            this.yearUp = new Button(this, 131076);
            listener = new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.handleSelection(event);
                }
            };
            this.yearDown.addListener(13, listener);
            this.monthDown.addListener(13, listener);
            this.monthUp.addListener(13, listener);
            this.yearUp.addListener(13, listener);
        }
    }

    static int checkStyle(int n) {
        n &= 0xFFFFFCFF;
        n = DateTime.checkBits(n, 65536, 32768, 0x10000000, 0, 0, 0);
        return DateTime.checkBits(n, 32, 128, 1024, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n == -1 || n2 == -1) {
            Object object;
            if ((this.style & 0x400) != 0) {
                object = this.getCellSize(null);
                Point point = this.monthDown.computeSize(-1, -1, bl);
                n3 = ((Point)object).x * 7;
                n4 = ((Point)object).y * 7 + Math.max(((Point)object).y, point.y);
            } else {
                object = new Rect();
                OS.GetBestControlRect(this.handle, (Rect)object, null);
                n3 = ((Rect)object).right - ((Rect)object).left;
                n4 = ((Rect)object).bottom - ((Rect)object).top;
            }
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    void createHandle() {
        int n = -1;
        if ((this.style & 0x80) != 0) {
            int n2 = n = (this.style & 0x8000) != 0 ? 0 : 1;
        }
        if ((this.style & 0x20) != 0) {
            int n3 = n = (this.style & 0x8000) != 0 ? 3 : 2;
        }
        if (n != -1) {
            int n4 = 0;
            int[] nArray = new int[1];
            int n5 = OS.GetControlOwner(this.parent.handle);
            OS.CreateClockControl(n5, null, n, n4, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.handle = nArray[0];
        } else {
            super.createHandle();
        }
    }

    void createWidget() {
        super.createWidget();
        this.getDate();
    }

    void drawDay(GC gC, Point point, int n) {
        int n2 = this.getCell(n);
        Point point2 = this.getCellLocation(n2, point);
        String string = String.valueOf(n);
        Point point3 = gC.stringExtent(string);
        int n3 = this.calendar.get(5);
        if (n == n3) {
            Display display = this.getDisplay();
            gC.setBackground(display.getSystemColor(26));
            gC.setForeground(display.getSystemColor(27));
            gC.fillRectangle(point2.x, point2.y, point.x, point.y);
        }
        gC.drawString(string, point2.x + (point.x - point3.x) / 2, point2.y + (point.y - point3.y) / 2, true);
        if (n == n3) {
            gC.setBackground(this.getBackground());
            gC.setForeground(this.getForeground());
        }
    }

    void drawDays(GC gC, Point point, Rectangle rectangle) {
        gC.setBackground(this.getBackground());
        gC.setForeground(this.getForeground());
        gC.fillRectangle(0, point.y, rectangle.width, point.y * 7);
        int n = this.calendar.getActualMinimum(5);
        int n2 = this.calendar.getActualMaximum(5);
        int n3 = n;
        while (n3 <= n2) {
            this.drawDay(gC, point, n3);
            ++n3;
        }
    }

    void drawDaysOfWeek(GC gC, Point point, Rectangle rectangle) {
        Display display = this.getDisplay();
        gC.setBackground(display.getSystemColor(22));
        gC.setForeground(display.getSystemColor(21));
        gC.fillRectangle(0, 0, rectangle.width, point.y);
        String[] stringArray = this.formatSymbols.getShortWeekdays();
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n3 < stringArray.length) {
            String string = stringArray[n3];
            Point point2 = gC.stringExtent(string);
            gC.drawString(string, n + (point.x - point2.x) / 2, n2 + (point.y - point2.y) / 2, true);
            n += point.x;
            ++n3;
        }
        gC.drawLine(0, point.y - 1, rectangle.width, point.y - 1);
    }

    void drawMonth(GC gC, Point point, Rectangle rectangle) {
        Display display = this.getDisplay();
        gC.setBackground(display.getSystemColor(22));
        gC.setForeground(display.getSystemColor(21));
        int n = point.y * 7;
        gC.fillRectangle(0, n, rectangle.width, point.y);
        gC.drawLine(0, n - 1, rectangle.width, n - 1);
        String string = String.valueOf(this.formatSymbols.getShortMonths()[this.calendar.get(2)]) + ", " + this.calendar.get(1);
        Point point2 = gC.stringExtent(string);
        gC.drawString(string, (point.x * 7 - point2.x) / 2, n + (point.y - point2.y) / 2, true);
    }

    void handleKeyDown(Event event) {
        int n = this.calendar.get(5);
        switch (event.keyCode) {
            case 0x1000002: {
                n += 7;
                break;
            }
            case 0x1000001: {
                n -= 7;
                break;
            }
            case 0x1000004: {
                ++n;
                break;
            }
            case 0x1000003: {
                --n;
            }
        }
        this.setDay(n, true);
    }

    void handleMouseDown(Event event) {
        this.setFocus();
        Point point = this.getCellSize(null);
        int n = event.x / point.x;
        int n2 = event.y / point.y;
        int n3 = n2 * 7 + n;
        int n4 = this.getDate(n3);
        this.setDay(n4, true);
    }

    void handlePaint(Event event) {
        GC gC = event.gc;
        Rectangle rectangle = this.getClientArea();
        Point point = this.getCellSize(gC);
        this.drawDaysOfWeek(gC, point, rectangle);
        this.drawDays(gC, point, rectangle);
        this.drawMonth(gC, point, rectangle);
    }

    void handleResize(Event event) {
        this.yearDown.pack();
        this.monthDown.pack();
        this.monthUp.pack();
        this.yearUp.pack();
        Point point = this.getCellSize(null);
        Point point2 = this.monthDown.getSize();
        int n = Math.max(point.y, point2.y);
        int n2 = point.y * 7 + (n - point2.y) / 2;
        this.yearDown.setLocation(0, n2);
        this.monthDown.setLocation(point2.x, n2);
        int n3 = point.x * 7 - point2.x;
        this.monthUp.setLocation(n3 - point2.x, n2);
        this.yearUp.setLocation(n3, n2);
    }

    void handleSelection(Event event) {
        if (event.widget == this.monthDown) {
            this.calendar.add(2, -1);
        } else if (event.widget == this.monthUp) {
            this.calendar.add(2, 1);
        } else if (event.widget == this.yearDown) {
            this.calendar.add(1, -1);
        } else if (event.widget == this.yearUp) {
            this.calendar.add(1, 1);
        } else {
            return;
        }
        this.redraw();
        this.postEvent(13);
    }

    void handleTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 256: 
            case 512: {
                event.doit = true;
            }
        }
    }

    Point getCellSize(GC gC) {
        boolean bl;
        boolean bl2 = bl = gC == null;
        if (gC == null) {
            gC = new GC(this);
        }
        int n = 0;
        int n2 = 0;
        String[] stringArray = this.formatSymbols.getShortWeekdays();
        int n3 = 0;
        while (n3 < stringArray.length) {
            Point point = gC.stringExtent(stringArray[n3]);
            n = Math.max(n, point.x);
            n2 = Math.max(n2, point.y);
            ++n3;
        }
        n3 = this.calendar.getMinimum(5);
        int n4 = this.calendar.getMaximum(5);
        int n5 = n3;
        while (n5 <= n4) {
            Point point = gC.stringExtent(String.valueOf(n5));
            n = Math.max(n, point.x);
            n2 = Math.max(n2, point.y);
            ++n5;
        }
        if (bl) {
            gC.dispose();
        }
        return new Point(n + 4, n2 + 2);
    }

    Point getCellLocation(int n, Point point) {
        return new Point(n % 7 * point.x, n / 7 * point.y);
    }

    int getCell(int n) {
        int n2 = this.calendar.get(5);
        this.calendar.set(5, 1);
        int n3 = n + this.calendar.get(7) + 5;
        this.calendar.set(5, n2);
        return n3;
    }

    void getDate() {
        this.dateRec = new LongDateRec();
        OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
    }

    int getDate(int n) {
        int n2 = this.calendar.get(5);
        this.calendar.set(5, 1);
        int n3 = n - this.calendar.get(7) - 5;
        this.calendar.set(5, n2);
        return n3;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.bg == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.bg;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.fg == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.fg;
    }

    public int getDay() {
        this.checkWidget();
        if ((this.style & 0x80) != 0) {
            return this.dateAndTime.day;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(5);
        }
        this.getDate();
        return this.dateRec.day;
    }

    public int getHours() {
        this.checkWidget();
        if ((this.style & 0x20) != 0) {
            return this.dateAndTime.hour;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(11);
        }
        this.getDate();
        return this.dateRec.hour;
    }

    public int getMinutes() {
        this.checkWidget();
        if ((this.style & 0x20) != 0) {
            return this.dateAndTime.minute;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(12);
        }
        this.getDate();
        return this.dateRec.minute;
    }

    public int getMonth() {
        this.checkWidget();
        if ((this.style & 0x80) != 0) {
            return this.dateAndTime.month - 1;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(2);
        }
        this.getDate();
        return this.dateRec.month - 1;
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds() : String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if ((this.style & 0x20) != 0) {
            return this.dateAndTime.second;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(13);
        }
        this.getDate();
        return this.dateRec.second;
    }

    public int getYear() {
        this.checkWidget();
        if ((this.style & 0x80) != 0) {
            return this.dateAndTime.year;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(1);
        }
        this.getDate();
        return this.dateRec.year;
    }

    void hookEvents() {
        super.hookEvents();
        if (OS.VERSION >= 4160) {
            int n = this.display.clockProc;
            int[] nArray = new int[]{1668050787, 1};
            int n2 = OS.GetControlEventTarget(this.handle);
            OS.InstallEventHandler(n2, n, nArray.length / 2, nArray, this.handle, null);
        }
    }

    boolean isValidTime(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        int n3 = calendar.getActualMinimum(n);
        int n4 = calendar.getActualMaximum(n);
        return n2 >= n3 && n2 <= n4;
    }

    boolean isValidDate(int n, int n2, int n3) {
        if (n < 1752 || n > 9999) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3);
        return calendar.get(1) == n && calendar.get(2) == n2 && calendar.get(5) == n3;
    }

    int kEventClockDateOrTimeChanged(int n, int n2, int n3) {
        this.sendSelectionEvent();
        return 0;
    }

    int kEventControlHit(int n, int n2, int n3) {
        int n4 = super.kEventControlHit(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (OS.VERSION < 4160) {
            this.sendSelectionEvent();
        }
        return n4;
    }

    int kEventTextInputUnicodeForKeyEvent(int n, int n2, int n3) {
        int n4 = super.kEventTextInputUnicodeForKeyEvent(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (OS.VERSION < 4160) {
            this.sendSelectionEvent();
        }
        return n4;
    }

    boolean pollTrackEvent() {
        return (this.style & 0x20) != 0 || (this.style & 0x80) != 0;
    }

    void redraw(int n, Point point) {
        Point point2 = this.getCellLocation(n, point);
        this.redraw(point2.x, point2.y, point.x, point.y, false);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.dateRec = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void sendSelectionEvent() {
        LongDateRec longDateRec = new LongDateRec();
        OS.GetControlData(this.handle, (short)0, 1684108389, 28, longDateRec, null);
        if (longDateRec.second != this.dateRec.second || longDateRec.minute != this.dateRec.minute || longDateRec.hour != this.dateRec.hour || longDateRec.day != this.dateRec.day || longDateRec.month != this.dateRec.month || longDateRec.year != this.dateRec.year) {
            this.dateRec = longDateRec;
            this.postEvent(13);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        super.setBackground(color);
        this.bg = color;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        super.setForeground(color);
        this.fg = color;
    }

    void setDay(int n, boolean bl) {
        int n2 = this.calendar.getActualMinimum(5);
        int n3 = this.calendar.getActualMaximum(5);
        if (n2 > n || n > n3) {
            return;
        }
        Point point = this.getCellSize(null);
        this.redraw(this.getCell(this.calendar.get(5)), point);
        this.calendar.set(5, n);
        this.redraw(this.getCell(this.calendar.get(5)), point);
        if (bl) {
            this.postEvent(13);
        }
    }

    public void setDate(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isValidDate(n, n2, n3)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(1, n);
            this.calendar.set(5, 1);
            this.calendar.set(2, n2);
            this.redraw();
            this.setDay(n3, false);
        } else {
            this.dateRec.year = (short)n;
            this.dateRec.month = (short)(n2 + 1);
            this.dateRec.day = (short)n3;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            this.redraw();
            if ((this.style & 0x80) != 0) {
                this.dateAndTime.year = (short)n;
                this.dateAndTime.month = (short)(n2 + 1);
                this.dateAndTime.day = (short)n3;
            }
        }
    }

    public void setDay(int n) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), this.getMonth(), n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.setDay(n, false);
        } else {
            this.dateRec.day = (short)n;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x80) != 0) {
                this.dateAndTime.day = (short)n;
            }
            this.redraw();
        }
    }

    public void setHours(int n) {
        this.checkWidget();
        if (!this.isValidTime(11, n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(11, n);
        } else {
            this.dateRec.hour = (short)n;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x20) != 0) {
                this.dateAndTime.hour = (short)n;
            }
        }
        this.redraw();
    }

    public void setMinutes(int n) {
        this.checkWidget();
        if (!this.isValidTime(12, n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(12, n);
        } else {
            this.dateRec.minute = (short)n;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x20) != 0) {
                this.dateAndTime.minute = (short)n;
            }
        }
        this.redraw();
    }

    public void setMonth(int n) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), n, this.getDay())) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(2, n);
        } else {
            this.dateRec.month = (short)(n + 1);
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x80) != 0) {
                this.dateAndTime.month = (short)(n + 1);
            }
        }
        this.redraw();
    }

    public void setSeconds(int n) {
        this.checkWidget();
        if (!this.isValidTime(13, n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(13, n);
        } else {
            this.dateRec.second = (short)n;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x20) != 0) {
                this.dateAndTime.second = (short)n;
            }
        }
        this.redraw();
    }

    public void setTime(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isValidTime(11, n)) {
            return;
        }
        if (!this.isValidTime(12, n2)) {
            return;
        }
        if (!this.isValidTime(13, n3)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(11, n);
            this.calendar.set(12, n2);
            this.calendar.set(13, n3);
        } else {
            this.dateRec.hour = (short)n;
            this.dateRec.minute = (short)n2;
            this.dateRec.second = (short)n3;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x20) != 0) {
                this.dateAndTime.hour = (short)n;
                this.dateAndTime.minute = (short)n2;
                this.dateAndTime.second = (short)n3;
            }
        }
        this.redraw();
    }

    public void setYear(int n) {
        this.checkWidget();
        if (!this.isValidDate(n, this.getMonth(), this.getDay())) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(1, n);
        } else {
            this.dateRec.year = (short)n;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x80) != 0) {
                this.dateAndTime.year = (short)n;
            }
        }
        this.redraw();
    }
}

