/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.StdLogger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class GetBuildToolsTask
extends Task {
    private static final FullRevision MIN_BUILD_TOOLS_REV = new FullRevision(19, 1, 0);
    private String mName;
    private boolean mVerbose = false;

    public void setName(String name) {
        this.mName = name;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void execute() throws BuildException {
        Project antProject = this.getProject();
        SdkManager sdkManager = SdkManager.createManager(antProject.getProperty("sdk.dir"), new StdLogger(this.mVerbose ? StdLogger.Level.VERBOSE : StdLogger.Level.ERROR));
        if (sdkManager == null) {
            throw new BuildException("Unable to parse the SDK!");
        }
        BuildToolInfo buildToolInfo = null;
        String buildToolsVersion = antProject.getProperty("sdk.buildtools");
        if (buildToolsVersion != null && (buildToolInfo = sdkManager.getBuildTool(FullRevision.parseRevision(buildToolsVersion))) == null) {
            throw new BuildException("Could not find Build Tools revision " + buildToolsVersion);
        }
        if (buildToolInfo == null) {
            buildToolInfo = sdkManager.getLatestBuildTool();
            if (buildToolInfo == null) {
                throw new BuildException("SDK does not have any Build Tools installed.");
            }
            System.out.println("Using latest Build Tools: " + buildToolInfo.getRevision());
        }
        if (buildToolInfo.getRevision().compareTo(MIN_BUILD_TOOLS_REV) < 0) {
            throw new BuildException(String.format("The SDK Build Tools revision (%1$s) is too low for project '%2$s'. Minimum required is %3$s", buildToolInfo.getRevision(), this.getProject().getName(), MIN_BUILD_TOOLS_REV));
        }
        antProject.setProperty(this.mName, buildToolInfo.getLocation().getAbsolutePath());
    }
}

