/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.math.BigInteger;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger$PyExposer;
import org.python.core.PyIntegerDerived;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="int", doc="int(x[, base]) -> integer\n\nConvert a string or number to an integer, if possible.  A floating point\nargument will be truncated towards zero (this does not include a string\nrepresentation of a floating point number!)  When converting a string, use\nthe optional base.  It is an error to supply a base when converting a\nnon-string. If the argument is outside the integer range a long object\nwill be returned instead.")
public class PyInteger
extends PyObject {
    public static final PyType TYPE;
    public static final BigInteger MIN_INT;
    public static final BigInteger MAX_INT;
    @Deprecated
    public static final BigInteger minInt;
    @Deprecated
    public static final BigInteger maxInt;
    private final int value;

    public PyInteger(PyType subType, int v) {
        super(subType);
        this.value = v;
    }

    public PyInteger(int v) {
        this(TYPE, v);
    }

    @ExposedNew
    public static PyObject int_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("int", args, keywords, new String[]{"x", "base"}, 0);
        PyObject x = ap.getPyObject(0, null);
        int base2 = ap.getInt(1, -909);
        if (new_.for_type == subtype) {
            if (x == null) {
                return Py.Zero;
            }
            if (base2 == -909) {
                if (x instanceof PyBoolean) {
                    return PyInteger.coerce(x) == 0 ? Py.Zero : Py.One;
                }
                return PyInteger.asPyInteger(x);
            }
            if (!(x instanceof PyString)) {
                throw Py.TypeError("int: can't convert non-string with explicit base");
            }
            try {
                return Py.newInteger(((PyString)x).atoi(base2));
            }
            catch (PyException pye) {
                if (pye.match(Py.OverflowError)) {
                    return ((PyString)x).atol(base2);
                }
                throw pye;
            }
        }
        if (x == null) {
            return new PyIntegerDerived(subtype, 0);
        }
        if (base2 == -909) {
            PyObject intOrLong = PyInteger.asPyInteger(x);
            if (intOrLong instanceof PyInteger) {
                return new PyIntegerDerived(subtype, ((PyInteger)intOrLong).getValue());
            }
            throw Py.OverflowError("long int too large to convert to int");
        }
        if (!(x instanceof PyString)) {
            throw Py.TypeError("int: can't convert non-string with explicit base");
        }
        return new PyIntegerDerived(subtype, ((PyString)x).atoi(base2));
    }

    private static PyObject asPyInteger(PyObject x) {
        try {
            return x.__int__();
        }
        catch (PyException pye) {
            if (!pye.match(Py.AttributeError)) {
                throw pye;
            }
            throw Py.TypeError("int() argument must be a string or a number");
        }
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.int_toString();
    }

    final String int_toString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public int hashCode() {
        return this.int_hashCode();
    }

    final int int_hashCode() {
        return this.getValue();
    }

    @Override
    public boolean __nonzero__() {
        return this.int___nonzero__();
    }

    final boolean int___nonzero__() {
        return this.getValue() != 0;
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c == Integer.TYPE || c == Number.class || c == Object.class || c == Integer.class || c == Serializable.class) {
            return new Integer(this.getValue());
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return new Boolean(this.getValue() != 0);
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return new Byte((byte)this.getValue());
        }
        if (c == Short.TYPE || c == Short.class) {
            return new Short((short)this.getValue());
        }
        if (c == Long.TYPE || c == Long.class) {
            return new Long(this.getValue());
        }
        if (c == Float.TYPE || c == Float.class) {
            return new Float(this.getValue());
        }
        if (c == Double.TYPE || c == Double.class) {
            return new Double(this.getValue());
        }
        return super.__tojava__(c);
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.int___cmp__(other);
    }

    final int int___cmp__(PyObject other) {
        if (!PyInteger.canCoerce(other)) {
            return -2;
        }
        int v = PyInteger.coerce(other);
        return this.getValue() < v ? -1 : (this.getValue() > v ? 1 : 0);
    }

    @Override
    public Object __coerce_ex__(PyObject other) {
        return this.int___coerce_ex__(other);
    }

    final PyObject int___coerce__(PyObject other) {
        return this.adaptToCoerceTuple(this.int___coerce_ex__(other));
    }

    final Object int___coerce_ex__(PyObject other) {
        return other instanceof PyInteger ? other : Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyInteger;
    }

    private static final int coerce(PyObject other) {
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __add__(PyObject right) {
        return this.int___add__(right);
    }

    final PyObject int___add__(PyObject right) {
        int b;
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int a = this.getValue();
        int x = a + (b = rightv);
        if ((x ^ a) >= 0 || (x ^ b) >= 0) {
            return Py.newInteger(x);
        }
        return new PyLong((long)a + (long)b);
    }

    @Override
    public PyObject __radd__(PyObject left) {
        return this.int___radd__(left);
    }

    final PyObject int___radd__(PyObject left) {
        return this.__add__(left);
    }

    private static PyObject _sub(int a, int b) {
        int x = a - b;
        if ((x ^ a) >= 0 || (x ^ ~b) >= 0) {
            return Py.newInteger(x);
        }
        return new PyLong((long)a - (long)b);
    }

    @Override
    public PyObject __sub__(PyObject right) {
        return this.int___sub__(right);
    }

    final PyObject int___sub__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        return PyInteger._sub(this.getValue(), PyInteger.coerce(right));
    }

    @Override
    public PyObject __rsub__(PyObject left) {
        return this.int___rsub__(left);
    }

    final PyObject int___rsub__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return PyInteger._sub(PyInteger.coerce(left), this.getValue());
    }

    @Override
    public PyObject __mul__(PyObject right) {
        return this.int___mul__(right);
    }

    final PyObject int___mul__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        double x = this.getValue();
        if ((x *= (double)rightv) <= 2.147483647E9 && x >= -2.147483648E9) {
            return Py.newInteger((int)x);
        }
        return this.__long__().__mul__(right);
    }

    @Override
    public PyObject __rmul__(PyObject left) {
        return this.int___rmul__(left);
    }

    final PyObject int___rmul__(PyObject left) {
        return this.__mul__(left);
    }

    private static long divide(long x, long y) {
        if (y == 0L) {
            throw Py.ZeroDivisionError("integer division or modulo by zero");
        }
        long xdivy = x / y;
        long xmody = x - xdivy * y;
        if (xmody != 0L && (y < 0L && xmody > 0L || y > 0L && xmody < 0L)) {
            xmody += y;
            --xdivy;
        }
        return xdivy;
    }

    @Override
    public PyObject __div__(PyObject right) {
        return this.int___div__(right);
    }

    final PyObject int___div__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(right)));
    }

    @Override
    public PyObject __rdiv__(PyObject left) {
        return this.int___rdiv__(left);
    }

    final PyObject int___rdiv__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(left), this.getValue()));
    }

    @Override
    public PyObject __floordiv__(PyObject right) {
        return this.int___floordiv__(right);
    }

    final PyObject int___floordiv__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(right)));
    }

    @Override
    public PyObject __rfloordiv__(PyObject left) {
        return this.int___rfloordiv__(left);
    }

    final PyObject int___rfloordiv__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(left), this.getValue()));
    }

    @Override
    public PyObject __truediv__(PyObject right) {
        return this.int___truediv__(right);
    }

    final PyObject int___truediv__(PyObject right) {
        if (right instanceof PyInteger) {
            return this.__float__().__truediv__(right);
        }
        if (right instanceof PyLong) {
            return this.int___long__().__truediv__(right);
        }
        return null;
    }

    @Override
    public PyObject __rtruediv__(PyObject left) {
        return this.int___rtruediv__(left);
    }

    final PyObject int___rtruediv__(PyObject left) {
        if (left instanceof PyInteger) {
            return left.__float__().__truediv__(this);
        }
        if (left instanceof PyLong) {
            return left.__truediv__(this.int___long__());
        }
        return null;
    }

    private static long modulo(long x, long y, long xdivy) {
        return x - xdivy * y;
    }

    @Override
    public PyObject __mod__(PyObject right) {
        return this.int___mod__(right);
    }

    final PyObject int___mod__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int v = this.getValue();
        return Py.newInteger(PyInteger.modulo(v, rightv, PyInteger.divide(v, rightv)));
    }

    @Override
    public PyObject __rmod__(PyObject left) {
        return this.int___rmod__(left);
    }

    final PyObject int___rmod__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        int leftv = PyInteger.coerce(left);
        int v = this.getValue();
        return Py.newInteger(PyInteger.modulo(leftv, v, PyInteger.divide(leftv, v)));
    }

    @Override
    public PyObject __divmod__(PyObject right) {
        return this.int___divmod__(right);
    }

    final PyObject int___divmod__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int v = this.getValue();
        long xdivy = PyInteger.divide(v, rightv);
        return new PyTuple(Py.newInteger(xdivy), Py.newInteger(PyInteger.modulo(v, rightv, xdivy)));
    }

    final PyObject int___rdivmod__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        int leftv = PyInteger.coerce(left);
        int v = this.getValue();
        long xdivy = PyInteger.divide(leftv, v);
        return new PyTuple(Py.newInteger(xdivy), Py.newInteger(PyInteger.modulo(leftv, v, xdivy)));
    }

    @Override
    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.int___pow__(right, modulo);
    }

    final PyObject int___pow__(PyObject right, PyObject modulo) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        if (modulo != null && !PyInteger.canCoerce(modulo)) {
            return null;
        }
        return PyInteger._pow(this.getValue(), PyInteger.coerce(right), modulo, this, right);
    }

    public PyObject __rpow__(PyObject left, PyObject modulo) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        if (modulo != null && !PyInteger.canCoerce(modulo)) {
            return null;
        }
        return PyInteger._pow(PyInteger.coerce(left), this.getValue(), modulo, left, this);
    }

    final PyObject int___rpow__(PyObject left) {
        return this.__rpow__(left, null);
    }

    private static PyObject _pow(int value, int pow, PyObject modulo, PyObject left, PyObject right) {
        int mod2 = 0;
        long tmp = value;
        boolean neg = false;
        if (tmp < 0L) {
            tmp = -tmp;
            neg = (pow & 1) != 0;
        }
        long result = 1L;
        if (pow < 0) {
            if (value != 0) {
                return left.__float__().__pow__(right, modulo);
            }
            throw Py.ZeroDivisionError("cannot raise 0 to a negative power");
        }
        if (modulo != null && (mod2 = PyInteger.coerce(modulo)) == 0) {
            throw Py.ValueError("pow(x, y, z) with z==0");
        }
        while (pow > 0) {
            if ((pow & 1) != 0) {
                result *= tmp;
                if (mod2 != 0) {
                    result %= (long)mod2;
                }
                if (result > Integer.MAX_VALUE) {
                    return left.__long__().__pow__(right, modulo);
                }
            }
            if ((pow >>= 1) == 0) break;
            tmp *= tmp;
            if (mod2 != 0) {
                tmp %= (long)mod2;
            }
            if (tmp <= Integer.MAX_VALUE) continue;
            return left.__long__().__pow__(right, modulo);
        }
        if (neg) {
            result = -result;
        }
        if (mod2 != 0) {
            result = PyInteger.modulo(result, mod2, PyInteger.divide(result, mod2));
        }
        return Py.newInteger(result);
    }

    @Override
    public PyObject __lshift__(PyObject right) {
        return this.int___lshift__(right);
    }

    final PyObject int___lshift__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__lshift__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        if (rightv >= 32) {
            return this.__long__().__lshift__(right);
        }
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        int result = this.getValue() << rightv;
        if (this.getValue() != result >> rightv) {
            return this.__long__().__lshift__(right);
        }
        return Py.newInteger(result);
    }

    final PyObject int___rlshift__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rlshift__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        if (this.getValue() >= 32) {
            return left.__long__().__lshift__(this);
        }
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        int result = leftv << this.getValue();
        if (leftv != result >> this.getValue()) {
            return left.__long__().__lshift__(this);
        }
        return Py.newInteger(result);
    }

    @Override
    public PyObject __rshift__(PyObject right) {
        return this.int___rshift__(right);
    }

    final PyObject int___rshift__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__rshift__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        if (rightv >= 32) {
            return Py.newInteger(this.getValue() < 0 ? -1 : 0);
        }
        return Py.newInteger(this.getValue() >> rightv);
    }

    final PyObject int___rrshift__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rshift__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        if (this.getValue() >= 32) {
            return Py.newInteger(leftv < 0 ? -1 : 0);
        }
        return Py.newInteger(leftv >> this.getValue());
    }

    @Override
    public PyObject __and__(PyObject right) {
        return this.int___and__(right);
    }

    final PyObject int___and__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__and__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() & rightv);
    }

    final PyObject int___rand__(PyObject left) {
        return this.int___and__(left);
    }

    @Override
    public PyObject __xor__(PyObject right) {
        return this.int___xor__(right);
    }

    final PyObject int___xor__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__xor__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() ^ rightv);
    }

    final PyObject int___rxor__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rxor__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        return Py.newInteger(leftv ^ this.getValue());
    }

    @Override
    public PyObject __or__(PyObject right) {
        return this.int___or__(right);
    }

    final PyObject int___or__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__or__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() | rightv);
    }

    final PyObject int___ror__(PyObject left) {
        return this.int___or__(left);
    }

    @Override
    public PyObject __neg__() {
        return this.int___neg__();
    }

    final PyObject int___neg__() {
        long x = -this.getValue();
        return Py.newInteger(x);
    }

    @Override
    public PyObject __pos__() {
        return this.int___pos__();
    }

    final PyObject int___pos__() {
        return this.int___int__();
    }

    @Override
    public PyObject __abs__() {
        return this.int___abs__();
    }

    final PyObject int___abs__() {
        if (this.getValue() < 0) {
            return this.int___neg__();
        }
        return this.int___int__();
    }

    @Override
    public PyObject __invert__() {
        return this.int___invert__();
    }

    final PyObject int___invert__() {
        return Py.newInteger(~this.getValue());
    }

    @Override
    public PyObject __int__() {
        return this.int___int__();
    }

    final PyInteger int___int__() {
        if (this.getType() == TYPE) {
            return this;
        }
        return Py.newInteger(this.getValue());
    }

    @Override
    public PyObject __long__() {
        return this.int___long__();
    }

    final PyObject int___long__() {
        return new PyLong(this.getValue());
    }

    @Override
    public PyFloat __float__() {
        return this.int___float__();
    }

    final PyFloat int___float__() {
        return new PyFloat((double)this.getValue());
    }

    @Override
    public PyComplex __complex__() {
        return new PyComplex(this.getValue(), 0.0);
    }

    @Override
    public PyString __oct__() {
        return this.int___oct__();
    }

    final PyString int___oct__() {
        if (this.getValue() < 0) {
            return new PyString("-0" + Integer.toString(this.getValue() * -1, 8));
        }
        return new PyString("0" + Integer.toString(this.getValue(), 8));
    }

    @Override
    public PyString __hex__() {
        return this.int___hex__();
    }

    final PyString int___hex__() {
        if (this.getValue() < 0) {
            return new PyString("-0x" + Integer.toString(this.getValue() * -1, 16));
        }
        return new PyString("0x" + Integer.toString(this.getValue(), 16));
    }

    final PyTuple int___getnewargs__() {
        return new PyTuple(new PyInteger(this.getValue()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.int___getnewargs__();
    }

    @Override
    public PyObject __index__() {
        return this.int___index__();
    }

    final PyObject int___index__() {
        return this;
    }

    @Override
    public boolean isIndex() {
        return true;
    }

    @Override
    public int asIndex(PyObject err) {
        return this.getValue();
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isNumberType() {
        return true;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    @Override
    public long asLong(int index) {
        return this.getValue();
    }

    @Override
    public int asInt(int index) {
        return this.getValue();
    }

    @Override
    public int asInt() {
        return this.getValue();
    }

    @Override
    public long asLong() {
        return this.getValue();
    }

    static {
        PyType.addBuilder(PyInteger.class, new PyInteger$PyExposer());
        TYPE = PyType.fromClass(PyInteger.class);
        MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
        MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
        minInt = MIN_INT;
        maxInt = MAX_INT;
    }
}

