/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.adaptor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadPathToFileCache {
    private final LRUCache<String, String> cache;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    public LoadPathToFileCache(int capacity) {
        this.cache = new LRUCache(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookup(List<String> loadPaths, String filename) {
        String filePathMapKey = LoadPathToFileCache.makeCacheKey(loadPaths, filename);
        this.cacheLock.readLock().lock();
        try {
            String string = (String)this.cache.get(filePathMapKey);
            return string;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(List<String> loadPaths, String filename, String filePath) {
        String filePathMapKey = LoadPathToFileCache.makeCacheKey(loadPaths, filename);
        this.cacheLock.writeLock().lock();
        try {
            this.cache.put(filePathMapKey, filePath);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    public static String makeCacheKey(List<String> loadPaths, String filename) {
        if (loadPaths == null) {
            throw new NullPointerException("Loadpaths cannot be null");
        }
        if (filename == null) {
            throw new NullPointerException("Filename cannot be null");
        }
        String loadPathsHash = Long.toHexString(LoadPathToFileCache.hashLoadPath(loadPaths));
        StringBuilder sb = new StringBuilder(loadPathsHash);
        sb.append('|').append(filename);
        return sb.toString();
    }

    static long hashLoadPath(List<String> list) {
        long hash = 17L;
        for (String path : list) {
            hash = 37L * hash + (long)path.hashCode();
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int capacity;

        LRUCache(int capacity) {
            super(capacity, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.capacity;
        }
    }
}

